/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.GameEvent;
import group24.escaperoom.data.GameEventBus;
import group24.escaperoom.data.Grid;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.LockedProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.ContainerUI;
import group24.escaperoom.ui.GameDialog;
import group24.escaperoom.ui.ItemSelectUI;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;
import java.util.Optional;
import java.util.logging.Logger;

public class ContainsItemProperty
extends ItemProperty<ContainedItem> {
    private static final PropertyDescription description = new PropertyDescription("Contains Items", "Can contain other items", "Items with the contains items property can hold items inside them.", null);
    protected Array<ItemSelectUI.SelectedItem> selectedItem = new Array();
    private Logger log = Logger.getLogger(ContainsItemProperty.class.getName());

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    public void addValue(ContainedItem o) {
        this.selectedItem.add(new ItemSelectUI.SelectedItem(o.inner));
    }

    public void removeItem(Item i) {
        this.selectedItem.removeValue(new ItemSelectUI.SelectedItem(i), false);
    }

    @Override
    public Array<ContainedItem> getPotentialValues() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Contained Items";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.ContainsItemsProperty;
    }

    @Override
    public void set(Array<ContainedItem> value) {
        this.selectedItem.clear();
        value.forEach(c -> this.addValue((ContainedItem)c));
    }

    @Override
    public ItemProperty.MenuType getInputType() {
        return ItemProperty.MenuType.PopOut;
    }

    @Override
    public ConfigurationMenu<ItemSelectUI> getPopOut(Menu.MenuEntry parent) {
        LevelEditorScreen editor = (LevelEditorScreen)parent.getScreen();
        Array<Item> potentialValues = new Array<Item>();
        for (Item item : editor.getGrid().placedItems.values()) {
            if (item.getID() == this.owner.getID() || !item.hasProperty(PropertyType.Containable)) continue;
            potentialValues.add(item);
        }
        this.selectedItem.forEach(si -> potentialValues.add(si.getItem()));
        ItemSelectUI ui = new ItemSelectUI(potentialValues, "No containable items are currently on the grid!", this.selectedItem, true, editor);
        ui.setOnSelect(i -> {
            i.setContained(true);
            i.remove(false);
            return null;
        });
        ui.setOnDeselect(i -> {
            i.setContained(false);
            editor.placeItem((Item)i);
            return null;
        });
        ConfigurationMenu<ItemSelectUI> m = new ConfigurationMenu<ItemSelectUI>(parent, ui, "Contains Items", editor);
        return m;
    }

    @Override
    public Array<ContainedItem> getCurrentValues() {
        Array<ContainedItem> items = new Array<ContainedItem>();
        this.selectedItem.forEach(si -> items.add(new ContainedItem(si.getItem(), this.owner)));
        return items;
    }

    @Override
    public Array<PlayerAction> getAvailableActions() {
        return Array.with(new OpenAction());
    }

    public ContainsItemProperty cloneProperty(Item newOwner) {
        ContainsItemProperty prop = new ContainsItemProperty();
        prop.owner = newOwner;
        return prop;
    }

    @Override
    public void write(Json json) {
        json.writeArrayStart("contained");
        this.selectedItem.forEach(contained -> json.writeValue(contained.getItem().getID()));
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        JsonValue containedData = jsonData.get("contained");
        Array ids = new Array();
        if (containedData != null) {
            containedData.forEach(itemJson -> {
                try {
                    ids.add(itemJson.asInt());
                }
                catch (Exception e) {
                    Item i = new Item();
                    i.read(json, (JsonValue)itemJson);
                    ids.add(i.getID());
                }
            });
        }
        Grid.onMapCompletion.add(g -> {
            ids.forEach(i -> this.selectedItem.add(new ItemSelectUI.SelectedItem(g.items.get(i))));
            return null;
        });
    }

    @Override
    public Class<ContainedItem> getValueClass() {
        return ContainedItem.class;
    }

    public class ContainedItem
    implements ItemPropertyValue {
        Item inner;

        public ContainedItem(Item item, Item container) {
            this.inner = item;
        }

        public Item getItem() {
            return this.inner;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContainedItem) {
                return ((ContainedItem)obj).getItem().getID() == this.getItem().getID();
            }
            return false;
        }
    }

    public class OpenAction
    implements PlayerAction {
        @Override
        public String getActionName() {
            return "Open";
        }

        @Override
        public PlayerAction.ActionResult act(GameContext ctx) {
            Optional<LockedProperty> locked = ContainsItemProperty.this.owner.getProperty(PropertyType.LockedProperty, LockedProperty.class);
            if (locked.isPresent() && locked.get().isLocked()) {
                LockedProperty lockedProp = locked.get();
                PlayerAction unlockAction = lockedProp.getCurrentValue().getUnlockAction(ctx);
                if (unlockAction != null) {
                    unlockAction.act(ctx);
                }
                if (lockedProp.isLocked()) {
                    GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message("Can't open " + ContainsItemProperty.this.owner.getItemName() + ", it is still locked!").build());
                    return PlayerAction.ActionResult.DEFAULT;
                }
            }
            return new PlayerAction.ActionResult().showsDialog(new GameDialog((Actor)new ContainerUI(ContainsItemProperty.this, ctx.player), ctx.player, "Contained..."));
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return true;
        }
    }
}

