/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ConditionallyActive;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.editor.PropertyConfiguration;
import java.util.Optional;

public abstract class ItemProperty<T extends ItemPropertyValue>
implements Json.Serializable {
    protected Item owner;

    public void setOwner(Item i) {
        this.owner = i;
    }

    public Item getOwner() {
        return this.owner;
    }

    public abstract Class<T> getValueClass();

    public abstract Array<T> getPotentialValues();

    public abstract String getDisplayName();

    public void defaultConfiguration(Item owner) {
        this.setOwner(owner);
    }

    public void apply(Item owner) {
        this.setOwner(owner);
    }

    public abstract PropertyDescription getDescription();

    public abstract PropertyType getType();

    public void set(Array<T> values) {
    }

    public void set(T value) {
    }

    public void unsafeSet(Array<ItemPropertyValue> value) {
        try {
            Array upcastVals = new Array();
            value.forEach(v -> upcastVals.add(v));
            this.set((T)upcastVals);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            System.err.println("unsafeSet failed to cast class -> set failed");
        }
    }

    public void unsafeSet(ItemPropertyValue value) {
        try {
            this.set(value);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            System.err.println("unsafeSet failed to cast class -> set failed");
        }
    }

    public abstract MenuType getInputType();

    public <CC extends Actor> ConfigurationMenu<CC> getPopOut(Menu.MenuEntry parent) {
        return null;
    }

    public Optional<PropertyConfiguration> getCustomItemConfigurationMenu() {
        return Optional.empty();
    }

    public Array<T> getCurrentValues() {
        return new Array();
    }

    public T getCurrentValue() {
        return null;
    }

    protected abstract Array<PlayerAction> getAvailableActions();

    public Array<PlayerAction> getActions(GameContext ctx) {
        if (this.owner == null) {
            throw new IllegalStateException();
        }
        return this.owner.getProperty(PropertyType.ConditionallyActive, ConditionallyActive.class).map(p -> p.isValid(ctx) ? this.getAvailableActions() : new Array()).orElseGet(() -> this.getAvailableActions());
    }

    public ItemProperty<? extends ItemPropertyValue> cloneProperty(Item newOwner) {
        ItemProperty<? extends ItemPropertyValue> p = this.getType().getEmptyProperty();
        p.owner = newOwner;
        p.read(new Json(), new JsonReader().parse(new Json().toJson(this)));
        return p;
    }

    public void updateTexture() {
    }

    public static enum MenuType {
        Toggleable,
        SelectOne,
        Select,
        PopOut,
        None;

    }
}

