/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.GameEvent;
import group24.escaperoom.data.GameEventBus;
import group24.escaperoom.data.Grid;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.FragileProperty;
import group24.escaperoom.entities.properties.LockingMethod;
import group24.escaperoom.entities.properties.LockingMethodType;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.UnlockerProperty;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.ItemSelectUI;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;
import java.util.HashSet;
import java.util.Optional;

public class KeyLock
extends LockingMethod {
    private Array<ItemSelectUI.SelectedItem> selectedItems = new Array();

    private Optional<Item> holdsKey(GameContext ctx) {
        for (Item i : ctx.player.getInventory()) {
            if (!this.selectedItems.contains(new ItemSelectUI.SelectedItem(i), false)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private void checkFragile(GameContext ctx, Item item) {
        item.getProperty(PropertyType.Fragile, FragileProperty.class).ifPresent(fp -> {
            if (fp.isTrue()) {
                ctx.player.removeItemFromInventory(item);
                GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(item.getItemName() + " was fragile and broke!").build());
            }
        });
    }

    private Optional<Item> trySetLock(GameContext ctx, boolean isLocked) {
        Optional<Item> maybeKey = this.holdsKey(ctx);
        if (maybeKey.isEmpty()) {
            String msg = "Hm, " + ((Item)this.owner.get()).getItemName() + " is still " + (this.isLocked ? "locked" : "unlocked");
            GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(msg).build());
        } else {
            this.updateLocked(ctx, isLocked);
        }
        return maybeKey;
    }

    private void updateLocked(GameContext ctx, boolean locked) {
        this.isLocked = locked;
        if (this.isBarrier) {
            ((Item)this.owner.get()).setBlocksPlayer(locked);
            ((Item)this.owner.get()).setAlpha(locked ? 1.0f : 0.5f);
        }
        GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(((Item)this.owner.get()).getItemName() + " is now " + (locked ? "locked!" : "unlocked!")).build());
    }

    @Override
    public String getName() {
        return "Key Lock";
    }

    @Override
    public LockingMethodType getType() {
        return LockingMethodType.KeyLock;
    }

    @Override
    public Menu.MenuEntry getDisplay(Menu parent) {
        return new Menu.MenuEntryBuilder(parent, this.getName()).spawns(e -> new ConfigurationMenu<ItemSelectUI>(e, this.configurationDisplay((LevelEditorScreen)parent.getScreen()), "Unlocked By", parent.getScreen())).build();
    }

    private ItemSelectUI configurationDisplay(LevelEditorScreen editor) {
        HashSet potentialValues = new HashSet();
        for (Item i : editor.getGrid().items.values()) {
            i.getProperty(PropertyType.UnlocksProperty, UnlockerProperty.class).ifPresent(p -> potentialValues.add(i));
        }
        Array<Item> potentialValueArray = Array.with(potentialValues.toArray(new Item[0]));
        ItemSelectUI ui = new ItemSelectUI(potentialValueArray, "No unlocker items on the grid!", this.selectedItems, true, editor);
        return ui;
    }

    @Override
    public Array<PlayerAction> getActions() {
        return Array.with(new TryUnlock(), new TryLock());
    }

    @Override
    protected LockingMethod getEmptyMethod() {
        return new KeyLock();
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeArrayStart("unlocked_by");
        this.selectedItems.forEach(si -> {
            if (si != null && si.getItem() != null) {
                json.writeValue(si.getItem().getID());
            }
        });
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue data) {
        super.read(json, data);
        JsonValue arr = data.get("unlocked_by");
        Array ids = new Array();
        if (arr != null) {
            arr.forEach(val -> ids.add(val.asInt()));
        }
        if (!ids.isEmpty()) {
            Grid.onMapCompletion.add(g -> {
                ids.forEach(id -> this.selectedItems.add(new ItemSelectUI.SelectedItem(g.items.get(id))));
                return null;
            });
        }
    }

    @Override
    protected PlayerAction maybeGetLockAction() {
        return new TryLock();
    }

    @Override
    protected PlayerAction maybeGetUnlockAction() {
        return new TryUnlock();
    }

    protected class TryUnlock
    implements PlayerAction {
        protected TryUnlock() {
        }

        @Override
        public String getActionName() {
            return "Try to unlock";
        }

        @Override
        public PlayerAction.ActionResult act(GameContext ctx) {
            KeyLock.this.trySetLock(ctx, false).ifPresent(key -> KeyLock.this.checkFragile(ctx, key));
            return PlayerAction.ActionResult.DEFAULT;
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return KeyLock.this.isLocked;
        }
    }

    protected class TryLock
    implements PlayerAction {
        protected TryLock() {
        }

        @Override
        public String getActionName() {
            return "Try to lock";
        }

        @Override
        public PlayerAction.ActionResult act(GameContext ctx) {
            KeyLock.this.trySetLock(ctx, true).ifPresent(key -> KeyLock.this.checkFragile(ctx, key));
            return PlayerAction.ActionResult.DEFAULT;
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return !KeyLock.this.isLocked;
        }
    }
}

