/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.LockingMethod;
import group24.escaperoom.entities.properties.LockingMethodType;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyMap;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.TrivialLock;
import group24.escaperoom.ui.editor.PropertyConfiguration;
import java.util.HashMap;
import java.util.Optional;

public class LockedProperty
extends ItemProperty<LockingMethod> {
    private static final PropertyDescription description = new PropertyDescription("Locked", "Prevents some interactions while locked", "Locked items may have various Locking methods, but all of them prevent some player interactions while locks.\nItems which contain other items cannot be opened while locked.\nItems which are barriers cannot be passed through while locked.", null);
    private LockingMethod currentMethod = new TrivialLock();
    private HashMap<LockingMethodType, LockingMethod> availableMethods = new HashMap();

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    public boolean isLocked() {
        return this.currentMethod.isLocked();
    }

    @Override
    public Array<LockingMethod> getPotentialValues() {
        Array<LockingMethod> methods = new Array<LockingMethod>();
        this.availableMethods.values().forEach(m -> methods.add((LockingMethod)m));
        return methods;
    }

    @Override
    public String getDisplayName() {
        return "Lock Property";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.LockedProperty;
    }

    @Override
    public void set(LockingMethod value) {
        this.currentMethod.onDetatch();
        this.currentMethod = value;
        this.currentMethod.onAttach(this.owner);
    }

    @Override
    public LockingMethod getCurrentValue() {
        return this.currentMethod;
    }

    @Override
    public ItemProperty.MenuType getInputType() {
        return ItemProperty.MenuType.SelectOne;
    }

    @Override
    public Array<PlayerAction> getAvailableActions() {
        return this.currentMethod.getActions();
    }

    public LockedProperty cloneProperty(Item newOwner) {
        LockedProperty ret = new LockedProperty();
        ret.owner = newOwner;
        ret.currentMethod = this.currentMethod.clone(newOwner);
        ret.availableMethods = new HashMap();
        this.availableMethods.forEach((t, m) -> ret.availableMethods.put((LockingMethodType)((Object)t), (LockingMethod)m));
        return ret;
    }

    @Override
    public void write(Json json) {
        json.writeObjectStart("default");
        json.writeValue("type", this.currentMethod.getType().key);
        this.currentMethod.write(json);
        json.writeObjectEnd();
        json.writeArrayStart("available");
        this.availableMethods.forEach((t, m) -> {
            json.writeObjectStart();
            json.writeValue("type", t.key);
            m.write(json);
            json.writeObjectEnd();
        });
        json.writeArrayEnd();
    }

    public LockingMethod getEmptyLockMethod(LockingMethodType type) {
        try {
            LockingMethod m_i = type.clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return m_i;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        JsonValue currentData;
        JsonValue available = jsonData.get("available");
        if (available != null) {
            available.forEach(data -> {
                LockingMethodType type_i = LockingMethodType.fromString(data.getString("type"));
                LockingMethod m_i = this.getEmptyLockMethod(type_i);
                m_i.read(json, (JsonValue)data);
                this.availableMethods.put(m_i.getType(), m_i);
            });
        }
        if ((currentData = jsonData.get("default")) == null) {
            this.currentMethod = this.availableMethods.isEmpty() ? new TrivialLock() : this.availableMethods.values().iterator().next();
        } else {
            LockingMethodType type = LockingMethodType.fromString(currentData.getString("type"));
            this.currentMethod = this.availableMethods.get((Object)type);
            if (this.currentMethod == null) {
                this.currentMethod = this.getEmptyLockMethod(type);
            }
        }
        PropertyMap.onMapCompletion.add(a -> {
            this.currentMethod.onAttach(this.owner);
            return null;
        });
    }

    @Override
    public Class<LockingMethod> getValueClass() {
        return LockingMethod.class;
    }

    @Override
    public Optional<PropertyConfiguration> getCustomItemConfigurationMenu() {
        PropertyConfiguration config = new PropertyConfiguration();
        config.addSelect("Availble Lock methods", null, new PropertyConfiguration.Select<LockingMethodType>(val -> this.availableMethods.put((LockingMethodType)((Object)((Object)val)), this.getEmptyLockMethod((LockingMethodType)((Object)((Object)val)))), val -> this.availableMethods.remove((Object)((LockingMethodType)((Object)((Object)val)))), LockingMethodType.values(), val -> ((LockingMethodType)((Object)((Object)val))).name(), LockingMethodType.values().length, this.availableMethods.keySet().toArray(new LockingMethodType[0])));
        return Optional.of(config);
    }
}

