/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.LockingMethodType;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.ui.editor.Menu;
import java.util.Optional;
import java.util.function.Function;

public abstract class LockingMethod
implements Json.Serializable,
ItemPropertyValue {
    protected boolean isBarrier = false;
    protected Optional<Item> owner = Optional.empty();
    protected boolean isLocked = true;

    public abstract String getName();

    public boolean isLocked() {
        return this.isLocked;
    }

    public abstract Array<PlayerAction> getActions();

    @Null
    public PlayerAction getUnlockAction(GameContext ctx) {
        return this.getAction(ctx, Void2 -> this.maybeGetUnlockAction());
    }

    @Null
    private PlayerAction getAction(GameContext ctx, Function<Void, PlayerAction> func) {
        if (this.owner.isEmpty()) {
            return null;
        }
        PlayerAction action = func.apply(null);
        if (action == null || !action.isValid(ctx)) {
            return null;
        }
        return action;
    }

    @Null
    public PlayerAction getLockAction(GameContext ctx) {
        return this.getAction(ctx, Void2 -> this.maybeGetUnlockAction());
    }

    @Null
    protected abstract PlayerAction maybeGetLockAction();

    @Null
    protected abstract PlayerAction maybeGetUnlockAction();

    public abstract LockingMethodType getType();

    public void onAttach(Item item) {
        this.owner = Optional.of(item);
        if (item.hasProperty(PropertyType.Barrier)) {
            item.setBlocksPlayer(true);
            this.isBarrier = true;
        }
    }

    public void onDetatch() {
        this.owner = Optional.empty();
    }

    @Override
    public Menu.MenuEntry getDisplay(Menu parent) {
        return new Menu.MenuEntryBuilder(parent, this.getName()).build();
    }

    @Override
    public void write(Json json) {
        json.writeValue("locked", this.isLocked);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.isLocked = jsonData.getBoolean("locked", true);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LockingMethod) {
            return this.getType() == ((LockingMethod)LockingMethod.class.cast(obj)).getType();
        }
        return false;
    }

    protected abstract LockingMethod getEmptyMethod();

    protected LockingMethod clone(Item newOwner) {
        LockingMethod p = this.getEmptyMethod();
        p.owner = Optional.of(newOwner);
        p.isLocked = this.isLocked;
        p.isBarrier = this.isBarrier;
        p.read(new Json(), new JsonReader().parse(new Json().toJson(this)));
        return p;
    }
}

