/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.GameEvent;
import group24.escaperoom.data.GameEventBus;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.PhantomProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import java.util.HashSet;
import java.util.Set;

public class ObtainableProperty
extends PhantomProperty {
    private static final PropertyDescription description = new PropertyDescription("Obtainable", "Can be picked up", "Obtainable properties can be obtained by the player", new HashSet<PropertyType>(Set.of(PropertyType.ContainsItemsProperty)));

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    @Override
    public String getDisplayName() {
        return "ObtainableProperty";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.Obtainable;
    }

    @Override
    public Array<PlayerAction> getAvailableActions() {
        return Array.with(new ObtainAction());
    }

    private class ObtainAction
    implements PlayerAction {
        private ObtainAction() {
        }

        @Override
        public String getActionName() {
            return "Pick up";
        }

        @Override
        public PlayerAction.ActionResult act(GameContext ctx) {
            ObtainableProperty.this.owner.remove(false);
            GameEvent ev = new GameEvent.Builder(GameEvent.EventType.ItemObtained, ctx).source(ObtainableProperty.this.owner).message("Added " + ObtainableProperty.this.owner.getItemName() + " to inventory!").build();
            GameEventBus.get().post(ev);
            return new PlayerAction.ActionResult().setCompletesInteraction(true);
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return !ctx.player.getInventory().contains(ObtainableProperty.this.owner, false);
        }
    }
}

