/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.GameEvent;
import group24.escaperoom.data.GameEventBus;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.LockingMethod;
import group24.escaperoom.entities.properties.LockingMethodType;
import group24.escaperoom.entities.properties.StringItemPropertyValue;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.ui.GameDialog;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.widgets.G24TextButton;
import group24.escaperoom.ui.widgets.G24TextInput;

public class PassphraseLock
extends LockingMethod
implements StringItemPropertyValue {
    public String passphrase = "a1b2";

    public PassphraseLock() {
    }

    public PassphraseLock(String val) {
        this.passphrase = val;
    }

    @Override
    public String getValue() {
        return this.passphrase;
    }

    @Override
    public void setValue(String value) {
        this.passphrase = value;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public Menu.MenuEntry getDisplay(Menu parent) {
        return new Menu.MenuEntryBuilder(parent, this.getName()).spawns(e -> new ConfigurationMenu<TextConfigurationContent>(e, this.configurationDisplay(), this.getName(), parent.getScreen())).build();
    }

    public TextConfigurationContent configurationDisplay() {
        final TextConfigurationContent input = new TextConfigurationContent(this.passphrase);
        input.setMaxLength(10);
        input.setWidth(100.0f);
        input.setAlphanumeric();
        input.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PassphraseLock.this.passphrase = input.getText();
            }
        });
        return input;
    }

    @Override
    public String getName() {
        return "Passphrase";
    }

    @Override
    public Array<PlayerAction> getActions() {
        return Array.with(new TryUnlock());
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("passphrase", this.passphrase);
    }

    @Override
    public void read(Json json, JsonValue data) {
        super.read(json, data);
        this.passphrase = data.getString("passphrase", "a12b");
    }

    @Override
    public LockingMethodType getType() {
        return LockingMethodType.PassphraseLock;
    }

    @Override
    protected LockingMethod getEmptyMethod() {
        return new PassphraseLock();
    }

    @Override
    protected PlayerAction maybeGetLockAction() {
        return null;
    }

    @Override
    protected PlayerAction maybeGetUnlockAction() {
        return new TryUnlock();
    }

    private class TextConfigurationContent
    extends G24TextInput
    implements ConfigurationMenu.HandlesMenuClose {
        public TextConfigurationContent(String content) {
            super(content);
        }

        @Override
        public void handle() {
        }
    }

    protected class TryUnlock
    implements PlayerAction {
        protected TryUnlock() {
        }

        @Override
        public String getActionName() {
            return "Enter passphrase";
        }

        @Override
        public PlayerAction.ActionResult act(final GameContext ctx) {
            if (ctx.player == null) {
                return PlayerAction.ActionResult.DEFAULT;
            }
            final GameDialog dialog = new GameDialog(ctx.player, "Enter Passphrase");
            Table table = new Table();
            final G24TextInput[] chars = new G24TextInput[PassphraseLock.this.passphrase.length()];
            for (int i = 0; i < PassphraseLock.this.passphrase.length(); ++i) {
                G24TextInput input = new G24TextInput();
                input.setMessageText("?");
                input.enableAutoFocusTraversal();
                input.setMaxLength(1);
                chars[i] = input;
            }
            final G24TextButton submitButton = new G24TextButton("Try Unlock");
            submitButton.setProgrammaticChangeEvents(false);
            submitButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (submitButton.isPressed()) {
                        String result = new String();
                        for (G24TextInput input : chars) {
                            result = result + input.getText();
                        }
                        if (result.equals(PassphraseLock.this.passphrase)) {
                            PassphraseLock.this.isLocked = false;
                            if (PassphraseLock.this.isBarrier) {
                                PassphraseLock.this.owner.ifPresent(i -> {
                                    i.setBlocksPlayer(false);
                                    i.setAlpha(0.5f);
                                });
                            }
                            dialog.hide();
                            submitButton.setDisabled(true);
                            GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(((Item)PassphraseLock.this.owner.get()).getItemName() + " clicked open...").build());
                            if (actor.getStage().getKeyboardFocus() instanceof G24TextInput) {
                                BackManager.goBack();
                            }
                            BackManager.goBack();
                        }
                    }
                    submitButton.setChecked(false);
                }
            });
            table.defaults().pad(0.0f).center();
            for (G24TextInput input : chars) {
                table.add(input).maxWidth(20.0f).minWidth(0.0f);
            }
            table.row();
            table.add(submitButton).align(1).colspan(chars.length);
            table.row();
            dialog.setContent(table);
            return new PlayerAction.ActionResult().showsDialog(dialog);
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return PassphraseLock.this.isLocked();
        }
    }
}

