/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.entities.player.PlayerDetails;
import group24.escaperoom.entities.properties.PhantomProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.ui.editor.PropertyConfiguration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class PlayerProperty
extends PhantomProperty {
    private static final PropertyDescription description = new PropertyDescription("Player", "The properties defining the player", "Allows the changing of the player's sprite, speed, and hitbox.", new HashSet<PropertyType>(Set.of(PropertyType.Animated, PropertyType.Barrier, PropertyType.Brushable, PropertyType.Collideable, PropertyType.Connector, PropertyType.ConnectorSource, PropertyType.ConnectorRelay, PropertyType.ConnectorSink, PropertyType.ConnectorBridge, PropertyType.CompletesLevel, PropertyType.ConditionallyActive, PropertyType.Containable, PropertyType.ContainsItemsProperty, PropertyType.CoveringProperty, PropertyType.Fragile, PropertyType.Interactable, PropertyType.LockedProperty, PropertyType.Obtainable, PropertyType.ReadableProperty, PropertyType.Spinable, PropertyType.Stylable, PropertyType.TiledBrushable, PropertyType.Toggleable, PropertyType.Unique, PropertyType.UnlocksProperty, PropertyType.Viewable)));
    private PlayerDetails details = new PlayerDetails();

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    public PlayerDetails getDetails() {
        return this.details;
    }

    @Override
    public String getDisplayName() {
        return "Player Property";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.Player;
    }

    @Override
    public void write(Json json) {
        this.details.write(json);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.details.read(json, jsonData);
        this.updateTexture();
    }

    @Override
    public void updateTexture() {
        this.owner.adjustTextureRegion(0, 0, this.details.textureInfo.frameWidth, this.details.textureInfo.frameHeight);
    }

    @Override
    public Optional<PropertyConfiguration> getCustomItemConfigurationMenu() {
        PropertyConfiguration config = new PropertyConfiguration();
        config.addElement("Hitbox", null, null, true);
        config.addNumberInput("Offset X", null, new PropertyConfiguration.FloatInput(this.details.hitboxInfo.xOffset, newVal -> {
            this.details.hitboxInfo.xOffset = newVal;
        }));
        config.addNumberInput("Offset Y", null, new PropertyConfiguration.FloatInput(this.details.hitboxInfo.yOffset, newVal -> {
            this.details.hitboxInfo.yOffset = newVal;
        }));
        config.addNumberInput("Width", null, new PropertyConfiguration.FloatInput(this.details.hitboxInfo.width, newVal -> {
            this.details.hitboxInfo.width = newVal;
        }));
        config.addNumberInput("Height", null, new PropertyConfiguration.FloatInput(this.details.hitboxInfo.height, newVal -> {
            this.details.hitboxInfo.height = newVal;
        }));
        config.addLine();
        config.addNumberInput("Speed", null, new PropertyConfiguration.FloatInput(this.details.speed, newVal -> {
            this.details.speed = newVal;
        }));
        config.addLine();
        config.addElement("Texture", null, null, true);
        config.addNumberInput("Idle Frames", null, new PropertyConfiguration.IntInput(this.details.textureInfo.idleFrames, newVal -> {
            this.details.textureInfo.idleFrames = newVal;
        }));
        config.addNumberInput("Idle Frame Delay (ms)", null, new PropertyConfiguration.IntInput(this.details.textureInfo.idleFrameDelayMS, newVal -> {
            this.details.textureInfo.idleFrameDelayMS = newVal;
        }));
        config.addNumberInput("Movement Frames", null, new PropertyConfiguration.IntInput(this.details.textureInfo.movementFrames, newVal -> {
            this.details.textureInfo.movementFrames = newVal;
        }));
        config.addNumberInput("Movement Frame Delay (ms)", null, new PropertyConfiguration.IntInput(this.details.textureInfo.moveFrameDelayMS, newVal -> {
            this.details.textureInfo.moveFrameDelayMS = newVal;
        }));
        config.addNumberInput("Frame Width", null, new PropertyConfiguration.IntInput(this.details.textureInfo.frameWidth, newVal -> {
            this.details.textureInfo.frameWidth = newVal;
        }));
        config.addNumberInput("Frame Height", null, new PropertyConfiguration.IntInput(this.details.textureInfo.frameHeight, newVal -> {
            this.details.textureInfo.frameHeight = newVal;
        }));
        return Optional.of(config);
    }
}

