/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.GameEvent;
import group24.escaperoom.data.GameEventBus;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ConnectorSink;
import group24.escaperoom.entities.properties.LockingMethod;
import group24.escaperoom.entities.properties.LockingMethodType;
import group24.escaperoom.entities.properties.PropertyType;

public class PowerLock
extends LockingMethod {
    @Override
    public String getName() {
        return "Power Lock";
    }

    @Override
    public Array<PlayerAction> getActions() {
        return Array.with(new TryUnlock());
    }

    @Override
    public LockingMethodType getType() {
        return LockingMethodType.PowerLock;
    }

    @Override
    protected LockingMethod getEmptyMethod() {
        return new PowerLock();
    }

    @Override
    protected PlayerAction maybeGetLockAction() {
        return null;
    }

    @Override
    protected PlayerAction maybeGetUnlockAction() {
        return new TryUnlock();
    }

    protected class TryUnlock
    implements PlayerAction {
        protected TryUnlock() {
        }

        @Override
        public String getActionName() {
            return "Try to Unlock";
        }

        @Override
        public PlayerAction.ActionResult act(GameContext ctx) {
            if (ctx.player == null) {
                return PlayerAction.ActionResult.DEFAULT;
            }
            ((Item)PowerLock.this.owner.get()).getProperty(PropertyType.ConnectorSink, ConnectorSink.class).ifPresent(csp -> {
                String eventMessage;
                if (csp.isConnected()) {
                    PowerLock.this.isLocked = false;
                    if (PowerLock.this.isBarrier) {
                        ((Item)PowerLock.this.owner.get()).setBlocksPlayer(false);
                        ((Item)PowerLock.this.owner.get()).setAlpha(0.5f);
                    }
                    eventMessage = ((Item)PowerLock.this.owner.get()).getItemName() + " is now unlocked!";
                } else {
                    eventMessage = ((Item)PowerLock.this.owner.get()).getItemName() + " is still locked!";
                }
                GameEvent ev = new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(eventMessage).build();
                GameEventBus.get().post(ev);
            });
            return PlayerAction.ActionResult.DEFAULT;
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return PowerLock.this.isLocked();
        }
    }
}

