/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.PropertyType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;

public class PropertyMap
extends HashMap<PropertyType, ItemProperty<? extends ItemPropertyValue>>
implements Json.Serializable {
    Item owner;
    public static HashSet<Function<Void, Void>> onMapCompletion = new HashSet();

    public void readWrapper(Item owner, Json json, JsonValue jsonData) {
        this.owner = owner;
        this.read(json, jsonData);
        PropertyMap.applyCallbacks();
    }

    @Override
    public void write(Json json) {
        this.forEach((type, property) -> {
            json.writeObjectStart();
            json.writeValue("property_type", type.asJsonString());
            property.write(json);
            json.writeObjectEnd();
        });
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        jsonData.forEach((? super T propData) -> {
            PropertyType propType = PropertyType.fromString(propData.getString("property_type"));
            if (propType == PropertyType.InvalidProperty) {
                return;
            }
            ItemProperty<? extends ItemPropertyValue> prop = propType.getEmptyProperty();
            prop.setOwner(this.owner);
            prop.read(json, (JsonValue)propData);
            this.put(propType, prop);
        });
    }

    public static void applyCallbacks() {
        onMapCompletion.forEach((? super T f) -> f.apply(null));
        onMapCompletion.clear();
    }
}

