/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import group24.escaperoom.entities.properties.AnimatedProperty;
import group24.escaperoom.entities.properties.Barrier;
import group24.escaperoom.entities.properties.Brushable;
import group24.escaperoom.entities.properties.Collideable;
import group24.escaperoom.entities.properties.CompletesLevel;
import group24.escaperoom.entities.properties.ConditionallyActive;
import group24.escaperoom.entities.properties.ConditionallyVisible;
import group24.escaperoom.entities.properties.Connector;
import group24.escaperoom.entities.properties.ConnectorBridge;
import group24.escaperoom.entities.properties.ConnectorRelay;
import group24.escaperoom.entities.properties.ConnectorSink;
import group24.escaperoom.entities.properties.ConnectorSource;
import group24.escaperoom.entities.properties.ContainableProperty;
import group24.escaperoom.entities.properties.ContainsItemProperty;
import group24.escaperoom.entities.properties.CoveringProperty;
import group24.escaperoom.entities.properties.FragileProperty;
import group24.escaperoom.entities.properties.InteractableProperty;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.LockedProperty;
import group24.escaperoom.entities.properties.ObtainableProperty;
import group24.escaperoom.entities.properties.PlayerProperty;
import group24.escaperoom.entities.properties.ReadableProperty;
import group24.escaperoom.entities.properties.SpinnableProperty;
import group24.escaperoom.entities.properties.Stylable;
import group24.escaperoom.entities.properties.TiledBrushable;
import group24.escaperoom.entities.properties.Toggleable;
import group24.escaperoom.entities.properties.Unique;
import group24.escaperoom.entities.properties.UnlockerProperty;
import group24.escaperoom.entities.properties.ViewableProperty;
import java.util.logging.Logger;

public enum PropertyType {
    Animated("animated", AnimatedProperty.class),
    Barrier("barrier", Barrier.class),
    Brushable("brush", Brushable.class),
    Collideable("collideable", Collideable.class),
    Connector("connector", Connector.class),
    ConnectorSource("connector_source", ConnectorSource.class),
    ConnectorRelay("connector_relay", ConnectorRelay.class),
    ConnectorSink("connector_sink", ConnectorSink.class),
    ConnectorBridge("connector_bridge", ConnectorBridge.class),
    CompletesLevel("completes_level", CompletesLevel.class),
    ConditionallyActive("conditionally_active", ConditionallyActive.class),
    ConditionallyVisible("conditionally_visible", ConditionallyVisible.class),
    Containable("containable", ContainableProperty.class),
    ContainsItemsProperty("containsitems", ContainsItemProperty.class),
    CoveringProperty("covering", CoveringProperty.class),
    Fragile("fragile", FragileProperty.class),
    Interactable("interactable", InteractableProperty.class),
    InvalidProperty("invalid", null),
    LockedProperty("locked", LockedProperty.class),
    Obtainable("obtainable", ObtainableProperty.class),
    Player("player", PlayerProperty.class),
    ReadableProperty("readable", ReadableProperty.class),
    Spinable("spinable", SpinnableProperty.class),
    Stylable("stylable", Stylable.class),
    TiledBrushable("tiled_brushable", TiledBrushable.class),
    Toggleable("toggleable", Toggleable.class),
    Unique("unique", Unique.class),
    UnlocksProperty("unlocker", UnlockerProperty.class),
    Viewable("viewable", ViewableProperty.class);

    private String jsonName;
    private Class<? extends ItemProperty<? extends ItemPropertyValue>> propClass;
    private static Logger log;

    public Class<? extends ItemProperty<? extends ItemPropertyValue>> getPropertyClass() {
        return this.propClass;
    }

    private PropertyType(String s, Class<? extends ItemProperty<? extends ItemPropertyValue>> c) {
        this.jsonName = s;
        this.propClass = c;
    }

    public String asJsonString() {
        return this.jsonName;
    }

    public ItemProperty<? extends ItemPropertyValue> getEmptyProperty() {
        if (this == InvalidProperty) {
            return null;
        }
        try {
            return this.propClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Cannot build property with unhandled type");
        }
    }

    public static PropertyType fromString(String s) {
        for (PropertyType t : PropertyType.values()) {
            if (!t.jsonName.equals(s)) continue;
            return t;
        }
        log.warning("Parsed Invalid Property: " + s);
        return InvalidProperty;
    }

    static {
        log = Logger.getLogger(PropertyType.class.getName());
    }
}

