/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.ReadableContents;
import group24.escaperoom.entities.properties.StringItemPropertyValue;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.GameDialog;
import group24.escaperoom.ui.SimpleUI;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.widgets.G24TextInput;

public class ReadableProperty
extends ItemProperty<ReadableContents> {
    private static final PropertyDescription description = new PropertyDescription("Readable", "Can be read", "Readable items provide the player with the Read action. The value of this property can be customized", null);
    ReadableContents contents = new ReadableContents();
    String title;
    String actionName = "Inspect";
    PlayerAction read = new PlayerAction(){

        @Override
        public boolean isValid(GameContext ctx) {
            return true;
        }

        @Override
        public PlayerAction.ActionResult act(GameContext ctx) {
            return new PlayerAction.ActionResult().showsDialog(new GameDialog((Actor)new SmallLabel(ReadableProperty.this.contents.getValue()), ctx.player, ReadableProperty.this.title));
        }

        @Override
        public String getActionName() {
            return ReadableProperty.this.actionName;
        }
    };

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    public ReadableProperty() {
        this("Hidden Info");
    }

    public ReadableProperty(String title) {
        this.title = title;
    }

    @Override
    public Array<ReadableContents> getPotentialValues() {
        return Array.with(this.contents);
    }

    @Override
    public String getDisplayName() {
        return "Readable";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.ReadableProperty;
    }

    @Override
    public void set(ReadableContents value) {
        this.contents = value;
    }

    @Override
    public ItemProperty.MenuType getInputType() {
        return ItemProperty.MenuType.PopOut;
    }

    @Override
    public ConfigurationMenu<SimpleUI> getPopOut(Menu.MenuEntry parent) {
        LevelEditorScreen screen = (LevelEditorScreen)parent.getScreen();
        final StringItemPropertyValue contents = (StringItemPropertyValue)StringItemPropertyValue.class.cast(this.getCurrentValue());
        final G24TextInput contentField = new G24TextInput(contents.getValue());
        contentField.setMaxLength(200);
        contentField.setMultiline(true);
        contentField.setPrefRows(2.0f);
        contentField.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                contents.setValue(contentField.getText());
            }
        });
        contentField.pack();
        final G24TextInput actionField = new G24TextInput(this.actionName);
        actionField.setMaxLength(200);
        actionField.setMultiline(false);
        actionField.setPrefRows(1.0f);
        actionField.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReadableProperty.this.actionName = actionField.getText();
            }
        });
        actionField.pack();
        VerticalGroup col = new VerticalGroup();
        col.space(10.0f);
        col.align(1);
        col.addActor(new SmallLabel("Action Name:", "underline", 0.65f));
        col.addActor(actionField);
        col.addActor(new SmallLabel("Contents:", "underline", 0.65f));
        col.addActor(contentField);
        return new ConfigurationMenu<SimpleUI>(parent, new SimpleUI((Actor)col), this.getDisplayName(), screen);
    }

    @Override
    public ReadableContents getCurrentValue() {
        return this.contents;
    }

    @Override
    public Array<PlayerAction> getAvailableActions() {
        return Array.with(this.read);
    }

    @Override
    public void write(Json json) {
        json.writeValue("title", this.title);
        json.writeValue("contents", this.contents.getValue());
        json.writeValue("action_name", this.actionName);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.title = jsonData.getString("title", "Hidden Info");
        this.contents = new ReadableContents(jsonData.getString("contents", "<nothing here>"));
        this.actionName = jsonData.getString("action_name", "Inspect");
    }

    @Override
    public Class<ReadableContents> getValueClass() {
        return ReadableContents.class;
    }
}

