/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.PhantomProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyMap;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.ui.editor.PropertyConfiguration;
import java.util.Optional;

public class SpinnableProperty
extends PhantomProperty {
    private static final PropertyDescription description = new PropertyDescription("Spinable", "Changes texture on rotation", "Spinable items have a texture that is 4 times as tall as the height of the item. This allows the texture of the item to change when it rotates. Ensure that any provided texture is four times as tall as it is normally would be for a nonspinable item", PropertyDescription.TEXTURE_CONFLICTS);
    private int width;
    private int height;
    private int spinCount = 0;
    private boolean symmetric = true;
    private int offset;
    public static final int PIXELS_PER_WORLD_UNIT = 16;

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    public SpinnableProperty() {
    }

    public SpinnableProperty(Item owner, int pixelWidth, int pixelHeight, int spinCount) {
        this.owner = owner;
        this.width = pixelWidth;
        this.height = pixelHeight;
        this.spinCount = 0;
        this.symmetric = this.width == this.height;
        this.offset = Math.max(this.width, this.height);
        this.setSpin(spinCount);
    }

    public void updateSize() {
        int temp = this.owner.itemSize.width;
        this.owner.itemSize.width = this.owner.itemSize.height;
        this.owner.itemSize.height = temp;
        this.owner.flip();
    }

    public void setSpin(int spinCount) {
        this.spinCount = spinCount % 4;
        this.updateTexture();
        this.updateSize();
    }

    public int getSpinCount() {
        return this.spinCount;
    }

    public static int degreesToSpinCount(float degrees) {
        return (int)(degrees % 360.0f) / 90;
    }

    @Override
    public String getDisplayName() {
        return "Spin";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.Spinable;
    }

    public SpinnableProperty cloneProperty(Item newOwner) {
        return new SpinnableProperty(newOwner, this.width, this.height, this.spinCount);
    }

    @Override
    public void updateTexture() {
        if (this.symmetric) {
            this.owner.adjustTextureRegion(0, this.offset * this.spinCount, this.width, this.height);
        } else if (this.spinCount % 2 == 0) {
            this.owner.adjustTextureRegion(0, this.offset * this.spinCount, this.width, this.height);
        } else {
            this.owner.adjustTextureRegion(0, this.offset * this.spinCount, this.height, this.width);
        }
    }

    private void updateDependentFields() {
        this.symmetric = this.width == this.height;
        this.offset = Math.max(this.width, this.height);
        this.spinCount = 0;
    }

    @Override
    public Optional<PropertyConfiguration> getCustomItemConfigurationMenu() {
        PropertyConfiguration config = new PropertyConfiguration();
        config.addNumberInput("Pixel Width", "The pixel width of this item", new PropertyConfiguration.IntInput(this.width, i -> {
            this.width = i;
            this.updateDependentFields();
            this.setSpin(0);
        }));
        config.addNumberInput("Pixel Height", "The pixel height of this item\n(the texure's height should be 4x this)", new PropertyConfiguration.IntInput(this.height, i -> {
            this.height = i;
            this.updateDependentFields();
            this.setSpin(0);
        }));
        return Optional.of(config);
    }

    @Override
    public void write(Json json) {
        json.writeValue("spin_count", this.spinCount);
        json.writeValue("pixel_width", this.width);
        json.writeValue("pixel_height", this.height);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.spinCount = jsonData.getInt("spin_count", 0);
        this.width = jsonData.getInt("pixel_width", this.owner.getWidth() * 16);
        this.height = jsonData.getInt("pixel_height", this.owner.getHeight() * 16);
        this.symmetric = this.width == this.height;
        this.offset = Math.max(this.width, this.height);
        PropertyMap.onMapCompletion.add(Void2 -> {
            this.updateTexture();
            if (this.owner.flipped) {
                this.updateSize();
            }
            return null;
        });
    }
}

