/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.AssetManager;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.ui.editor.Menu;
import java.util.logging.Logger;

public class Stylable
extends ItemProperty<Style> {
    private Array<Style> availableStyles = new Array();
    private Style currentStyle;
    private Logger log = Logger.getLogger(Stylable.class.getName());
    private static final PropertyDescription description = new PropertyDescription("Stylable", "Has multiple available textures", "Stylable items can have multiple textures. Primarily a convienence to avoid creating multiple items that differ only in their texture.", null);

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    @Override
    public void write(Json json) {
        if (this.currentStyle == null) {
            this.buildDefaultStyle();
        }
        json.writeArrayStart("available");
        this.availableStyles.forEach(s -> {
            json.writeObjectStart();
            s.write(json);
            json.writeObjectEnd();
        });
        json.writeArrayEnd();
        json.writeValue("current", this.currentStyle);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        JsonValue available = jsonData.get("available");
        available.forEach(s -> {
            Style style = new Style();
            style.read(json, (JsonValue)s);
            this.availableStyles.add(style);
        });
        this.currentStyle = new Style();
        JsonValue current = jsonData.get("current");
        if (current != null) {
            this.currentStyle.read(json, current);
        } else {
            this.currentStyle.name = "Default";
            this.currentStyle.texture = this.owner.getType().texture;
        }
        this.currentStyle.apply(this.owner);
    }

    @Override
    public String getDisplayName() {
        return "Stylable";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.Stylable;
    }

    @Override
    public void set(Style value) {
        this.currentStyle = value;
        this.currentStyle.apply(this.owner);
    }

    @Override
    public ItemProperty.MenuType getInputType() {
        return ItemProperty.MenuType.SelectOne;
    }

    private void buildDefaultStyle() {
        this.currentStyle = new Style("Default", this.owner.getType().texture);
        this.availableStyles.add(this.currentStyle);
    }

    @Override
    public Style getCurrentValue() {
        if (this.currentStyle == null) {
            this.buildDefaultStyle();
        }
        return this.currentStyle;
    }

    @Override
    public Array<PlayerAction> getAvailableActions() {
        return new Array<PlayerAction>();
    }

    @Override
    public Array<Style> getPotentialValues() {
        return this.availableStyles;
    }

    @Override
    public Class<Style> getValueClass() {
        return Style.class;
    }

    public class Style
    implements ItemPropertyValue,
    Json.Serializable {
        private String name;
        private String texture;

        public Style() {
        }

        public Style(String name, String texture) {
            this.name = name;
            this.texture = texture;
        }

        public String getStyleName() {
            return this.name;
        }

        public void apply(Item to) {
            Stylable.this.log.fine("applying texture: " + this.getTexture() + " to item " + to.getItemName() + " id: " + to.getID());
            TextureAtlas.AtlasRegion ar = new TextureAtlas.AtlasRegion(this.getTexture());
            ar.setRegionWidth(to.getTexture().getRegionWidth());
            ar.setRegionHeight(to.getTexture().getRegionHeight());
            to.setTexture(ar);
        }

        @Override
        public void write(Json json) {
            json.writeValue("name", this.name);
            json.writeValue("texture", this.texture);
        }

        @Override
        public void read(Json json, JsonValue jsonData) {
            this.name = jsonData.getString("name", "");
            this.texture = jsonData.getString("texture", Stylable.this.owner.getType().texture);
            int pngInd = this.texture.lastIndexOf(".png");
            if (pngInd != -1) {
                this.texture = this.texture.substring(0, pngInd);
            }
        }

        public TextureAtlas.AtlasRegion getTexture() {
            return AssetManager.instance().getRegion(this.texture);
        }

        @Override
        public Menu.MenuEntry getDisplay(Menu parent) {
            return new Menu.MenuEntryBuilder(parent, this.getStyleName()).onSelect(() -> this.apply(Stylable.this.owner)).build();
        }
    }
}

