/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.GameEvent;
import group24.escaperoom.data.GameEventBus;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ConnectorSource;
import group24.escaperoom.entities.properties.FragileProperty;
import group24.escaperoom.entities.properties.PhantomProperty;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyMap;
import group24.escaperoom.entities.properties.PropertyType;
import java.util.HashSet;
import java.util.Optional;

public class Toggleable
extends PhantomProperty {
    private boolean isToggled = false;
    private String toggleVerb = "clicked...";
    private int width;
    private int height;
    private static final PropertyDescription description = new PropertyDescription("Togglable", "Toggle between two states", "Items with this property provide the player with a Toggle action which toggles that item between two different states", new HashSet<PropertyType>());

    private void toggleTo(boolean toggleTo, GameContext ctx) {
        this.isToggled = toggleTo;
        GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(this.owner.getItemName() + " " + this.toggleVerb).build());
        this.owner.getProperty(PropertyType.ConnectorSource, ConnectorSource.class).ifPresent(csp -> csp.setActive(this.isToggled, ctx));
    }

    @Override
    public String getDisplayName() {
        return "Toggleable";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.Toggleable;
    }

    public boolean isToggled() {
        return this.isToggled;
    }

    @Override
    public Array<PlayerAction> getAvailableActions() {
        return Array.with(new ToggleAction());
    }

    @Override
    public void write(Json json) {
        json.writeValue("verb", this.toggleVerb);
        json.writeValue("toggled", this.isToggled);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.toggleVerb = jsonData.getString("verb", "clicked...");
        this.isToggled = jsonData.getBoolean("toggled", false);
        this.width = 16 * this.owner.getWidth();
        this.height = 16 * this.owner.getHeight();
        PropertyMap.onMapCompletion.add(Void2 -> {
            this.updateTexture();
            return null;
        });
    }

    @Override
    public void updateTexture() {
        if (this.isToggled) {
            this.owner.adjustTextureRegion(this.width, 0, this.width, this.height);
        } else {
            this.owner.adjustTextureRegion(0, 0, this.width, this.height);
        }
    }

    @Override
    public void defaultConfiguration(Item owner) {
        super.defaultConfiguration(owner);
        this.width = owner.getTexture().getRegionWidth() / 2;
        this.height = owner.getTexture().getRegionHeight();
    }

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    private class ToggleAction
    implements PlayerAction {
        private ToggleAction() {
        }

        @Override
        public String getActionName() {
            return "Toggle";
        }

        @Override
        public PlayerAction.ActionResult act(GameContext ctx) {
            Optional<FragileProperty> ofp = Toggleable.this.owner.getProperty(PropertyType.Fragile, FragileProperty.class);
            if (ofp.isPresent()) {
                FragileProperty fp = ofp.get();
                if (fp.isBroken()) {
                    GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(Toggleable.this.owner.getItemName() + " is broken and won't move").build());
                    return PlayerAction.ActionResult.DEFAULT;
                }
                if (fp.isTrue()) {
                    GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(Toggleable.this.owner.getItemName() + " was fragile and broke!").build());
                    fp.setBroken(true);
                }
            } else {
                GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(Toggleable.this.owner.getItemName() + " " + Toggleable.this.toggleVerb).build());
            }
            Toggleable.this.toggleTo(!Toggleable.this.isToggled, ctx);
            Toggleable.this.updateTexture();
            return PlayerAction.ActionResult.DEFAULT;
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return true;
        }
    }
}

