/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.GameEvent;
import group24.escaperoom.data.GameEventBus;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.LockingMethod;
import group24.escaperoom.entities.properties.LockingMethodType;

public class TrivialLock
extends LockingMethod {
    @Override
    public String getName() {
        return "Unlocked";
    }

    @Override
    public Array<PlayerAction> getActions() {
        return Array.with(new TryUnlock());
    }

    @Override
    public LockingMethodType getType() {
        return LockingMethodType.TrivialLock;
    }

    @Override
    protected LockingMethod getEmptyMethod() {
        return new TrivialLock();
    }

    @Override
    protected PlayerAction maybeGetLockAction() {
        return null;
    }

    @Override
    protected PlayerAction maybeGetUnlockAction() {
        return new TryUnlock();
    }

    protected class TryUnlock
    implements PlayerAction {
        protected TryUnlock() {
        }

        @Override
        public String getActionName() {
            return "Try to unlock";
        }

        @Override
        public PlayerAction.ActionResult act(GameContext ctx) {
            if (ctx.player == null) {
                return new PlayerAction.ActionResult();
            }
            if (TrivialLock.this.isBarrier) {
                ((Item)TrivialLock.this.owner.get()).setBlocksPlayer(false);
                ((Item)TrivialLock.this.owner.get()).setAlpha(0.75f);
            }
            TrivialLock.this.isLocked = false;
            GameEventBus.get().post(new GameEvent.Builder(GameEvent.EventType.ItemStateChange, ctx).message(((Item)TrivialLock.this.owner.get()).getItemName() + " was unlocked!").build());
            return new PlayerAction.ActionResult();
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return TrivialLock.this.isLocked;
        }
    }
}

