/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.PropertyDescription;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.ui.DrawingPane;
import group24.escaperoom.ui.DrawingUI;
import group24.escaperoom.ui.GameDialog;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;
import java.io.ByteArrayOutputStream;

public class ViewableProperty
extends ItemProperty<ImageValue> {
    private static final PropertyDescription description = new PropertyDescription("Viewable", "Contains a picture", "Viewable items have a configurable image diplayed to the player when they take the View action", null);
    ImageValue value;

    @Override
    public PropertyDescription getDescription() {
        return description;
    }

    @Override
    public void write(Json json) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PixmapIO.PNG png = new PixmapIO.PNG();
        png.setFlipY(false);
        try {
            png.write(baos, this.value.inner);
            baos.close();
        }
        catch (Exception e) {
            System.out.println("failed to write pixmap");
        }
        char[] encoded = Base64Coder.encode(baos.toByteArray());
        json.writeValue("data", new String(encoded));
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.value = new ImageValue();
        String base64 = jsonData.getString("data", "");
        if (!base64.isEmpty()) {
            byte[] pngBytes = Base64Coder.decode(base64);
            this.value.inner = new Pixmap(pngBytes, 0, pngBytes.length);
        } else {
            this.value.inner = new Pixmap(200, 200, Pixmap.Format.RGBA8888);
            this.value.inner.setColor(DrawingPane.canvasColor);
            this.value.inner.fill();
        }
    }

    @Override
    public Class<ImageValue> getValueClass() {
        return ImageValue.class;
    }

    @Override
    public Array<ImageValue> getPotentialValues() {
        return new Array<ImageValue>();
    }

    @Override
    public String getDisplayName() {
        return "Viewable";
    }

    @Override
    public PropertyType getType() {
        return PropertyType.Viewable;
    }

    @Override
    public void set(ImageValue value) {
        this.value = value;
    }

    @Override
    public ItemProperty.MenuType getInputType() {
        return ItemProperty.MenuType.PopOut;
    }

    @Override
    public ConfigurationMenu<DrawingUI> getPopOut(Menu.MenuEntry parent) {
        return new ConfigurationMenu<DrawingUI>(parent, new DrawingUI(this.value.inner, parent.getScreen()), "Draw pane", parent.getScreen());
    }

    @Override
    public ImageValue getCurrentValue() {
        return this.value;
    }

    @Override
    protected Array<PlayerAction> getAvailableActions() {
        return Array.with(new ViewAction());
    }

    public static class ImageValue
    implements ItemPropertyValue {
        Pixmap inner;
    }

    private class ViewAction
    implements PlayerAction {
        private ViewAction() {
        }

        @Override
        public String getActionName() {
            return "View";
        }

        @Override
        public PlayerAction.ActionResult act(GameContext ctx) {
            Texture texture = new Texture(ViewableProperty.this.value.inner);
            texture.draw(ViewableProperty.this.value.inner, 0, 0);
            return new PlayerAction.ActionResult().showsDialog(new GameDialog((Actor)new Image(texture), ctx.player, "Viewing" + ViewableProperty.this.owner.getItemName()));
        }

        @Override
        public boolean isValid(GameContext ctx) {
            return true;
        }
    }
}

