/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.properties.conditionals.Conditional;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.entities.properties.conditionals.EmptyConditional;
import group24.escaperoom.screens.LevelEditorScreen;
import java.util.Optional;
import java.util.logging.Logger;

public abstract class BinaryConditional
extends Conditional {
    private Logger log = Logger.getLogger(BinaryConditional.class.getName());
    protected Conditional left = new EmptyConditional();
    protected Conditional right = new EmptyConditional();

    @Override
    public boolean requiresPoll() {
        return this.left.requiresPoll() || this.right.requiresPoll();
    }

    @Override
    public boolean poll(GameContext ctx) {
        boolean leftNeeds = this.left.poll(ctx);
        boolean rightNeeds = this.right.poll(ctx);
        return leftNeeds || rightNeeds;
    }

    @Override
    public void write(Json json) {
        json.writeObjectStart("left");
        json.writeValue("type", (Object)this.left.getType());
        this.left.write(json);
        json.writeObjectEnd();
        json.writeObjectStart("right");
        json.writeValue("type", (Object)this.right.getType());
        this.right.write(json);
        json.writeObjectEnd();
    }

    private Conditional readCond(JsonValue data) {
        String type = data.getString("type");
        ConditionalType t = ConditionalType.valueOf(type);
        Conditional c = t.getConditional();
        c.read(new Json(), data);
        return c;
    }

    @Override
    public void setChildren(Conditional ... conds) {
        if (conds.length > 2) {
            this.log.warning("BinaryConditional setChildren got more than two values");
        }
        if (conds.length > 0) {
            this.left = conds[0];
        }
        if (conds.length > 1) {
            this.right = conds[1];
        }
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.left = this.readCond(jsonData.get("left"));
        this.right = this.readCond(jsonData.get("right"));
    }

    @Override
    public Array<Conditional> getChildren() {
        return Array.with(this.left, this.right);
    }

    @Override
    public Optional<Integer> childCount() {
        return Optional.of(2);
    }

    public Optional<Actor> getEditorConfiguration(LevelEditorScreen editor) {
        return Optional.empty();
    }
}

