/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.conditionals.AlwaysActive;
import group24.escaperoom.entities.properties.conditionals.Conditional;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.entities.properties.conditionals.EmptyConditional;
import group24.escaperoom.ui.conditionals.ConditionalUI;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;

public abstract class ConditionalProperty
extends ItemProperty<Conditional> {
    protected Conditional condition;

    public boolean requiresPoll() {
        return this.condition.requiresPoll();
    }

    public boolean poll(GameContext ctx) {
        return this.condition.poll(ctx);
    }

    @Override
    public void write(Json json) {
        if (this.condition == null) {
            this.condition = new AlwaysActive();
        }
        json.writeObjectStart("condition");
        json.writeValue("type", (Object)this.condition.getType());
        this.condition.write(json);
        json.writeObjectEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        JsonValue condition = jsonData.get("condition");
        if (condition != null) {
            String type = condition.getString("type");
            ConditionalType t = ConditionalType.valueOf(type);
            Conditional c = t.getConditional();
            c.read(json, condition);
            this.condition = c;
        } else {
            this.condition = new AlwaysActive();
        }
    }

    @Override
    public Array<Conditional> getPotentialValues() {
        Array<Conditional> conditions = new Array<Conditional>();
        for (ConditionalType c : ConditionalType.values()) {
            conditions.add(c.getConditional());
        }
        return conditions;
    }

    public boolean isValid(GameContext ctx) {
        return this.condition.evaluate(ctx);
    }

    public void update(GameContext ctx) {
    }

    @Override
    public void set(Conditional value) {
        if (value == null) {
            this.condition = new EmptyConditional();
        }
        this.condition = value;
    }

    @Override
    public Conditional getCurrentValue() {
        return this.condition;
    }

    @Override
    protected Array<PlayerAction> getAvailableActions() {
        return new Array<PlayerAction>();
    }

    @Override
    public ItemProperty.MenuType getInputType() {
        return ItemProperty.MenuType.PopOut;
    }

    @Override
    public ConfigurationMenu<ConditionalUI> getPopOut(Menu.MenuEntry parent) {
        ConfigurationMenu<ConditionalUI> m = new ConfigurationMenu<ConditionalUI>(parent, this.getDisplayName(), parent.getScreen());
        m.setContent(new ConditionalUI(this, m));
        return m;
    }

    @Override
    public Class<Conditional> getValueClass() {
        return Conditional.class;
    }
}

