/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.Input;
import group24.escaperoom.control.InputOverride;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.Grid;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.ContainsItemProperty;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.conditionals.Conditional;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.GridView;
import group24.escaperoom.ui.ItemSelectUI;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import java.util.Optional;
import java.util.Set;

public class ItemContainsItem
extends Conditional {
    ItemSelectUI.SelectedItem container = new ItemSelectUI.SelectedItem();
    ItemSelectUI.SelectedItem contained = new ItemSelectUI.SelectedItem();

    @Override
    public boolean evaluate(GameContext ctx) {
        if (this.container.getItem() == null || this.contained.getItem() == null) {
            return false;
        }
        return this.container.getItem().getProperty(PropertyType.ContainsItemsProperty, ContainsItemProperty.class).map(cip -> {
            for (ContainsItemProperty.ContainedItem i : cip.getCurrentValues()) {
                if (i.getItem().getID() != this.contained.getItem().getID()) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    public ConditionalType getType() {
        return ConditionalType.ItemContainsItem;
    }

    @Override
    public String getName() {
        return "Item contains Item";
    }

    public void removeStaleItems() {
        if (this.contained.getItem() == null || !Grid.current().items.containsKey(this.contained.getItem().getID())) {
            this.contained = new ItemSelectUI.SelectedItem();
        }
        if (this.container.getItem() == null || !Grid.current().items.containsKey(this.container.getItem().getID())) {
            this.container = new ItemSelectUI.SelectedItem();
        }
    }

    @Override
    public void write(Json json) {
        this.removeStaleItems();
        json.writeValue("container_id", this.container.getItem() == null ? -1 : this.container.getItem().getID());
        json.writeValue("contained_id", this.contained.getItem() == null ? -1 : this.contained.getItem().getID());
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        int containerID = jsonData.getInt("container_id", -1);
        int containedID = jsonData.getInt("contained_id", -1);
        Grid.onMapCompletion.add(grid -> {
            if (containerID != -1) {
                this.container = new ItemSelectUI.SelectedItem(grid.items.get(containerID));
            }
            if (containedID != -1) {
                this.contained = new ItemSelectUI.SelectedItem(grid.items.get(containedID));
            }
            return null;
        });
    }

    public Optional<Actor> getEditorConfiguration(LevelEditorScreen editor) {
        this.removeStaleItems();
        Array<Item> potentialContainers = new Array<Item>();
        Array<Item> potentialContained = new Array<Item>();
        Grid.current().items.forEach((_id, item) -> {
            if (item.hasProperty(PropertyType.ContainsItemsProperty)) {
                potentialContainers.add((Item)item);
            }
            if (item.hasProperty(PropertyType.Containable)) {
                potentialContained.add((Item)item);
            }
        });
        final ItemSelectUI select1 = new ItemSelectUI(potentialContainers, this.container, "No containers on the map!", editor);
        final ItemSelectUI select2 = new ItemSelectUI(potentialContained, this.contained, "No containable items on the map!", editor);
        final class DoubleSelectOverride
        implements InputOverride {
            DoubleSelectOverride() {
            }

            @Override
            public boolean handleInput(Input input, ControlsManager.InputType type) {
                boolean handle1 = select1.getInputOverride().handleInput(input, type);
                boolean handle2 = select2.getInputOverride().handleInput(input, type);
                return handle1 || handle2;
            }

            @Override
            public Set<Input> getOverriddenInputs() {
                return select1.getInputOverride().getOverriddenInputs();
            }
        }
        final DoubleSelectOverride override = new DoubleSelectOverride();
        ControlsManager.pushOverride(override);
        final class ItemContainsItemUI
        extends VerticalGroup
        implements ConfigurationMenu.HandlesMenuClose {
            ItemContainsItemUI() {
            }

            @Override
            public void handle() {
                ControlsManager.popOverride(override);
                select2.handle();
                select1.handle();
            }
        }
        ItemContainsItemUI ui = new ItemContainsItemUI();
        ui.space(20.0f);
        ui.align(1);
        ui.addActor(new SmallLabel("Container:", "bubble"));
        ui.addActor(select1);
        ui.addActor(new SmallLabel("Contained:", "bubble"));
        ui.addActor(select2);
        editor.clearGridView();
        editor.setGridView(GridView.compose(select1.getGridView(), select2.getGridView()));
        return Optional.of(ui);
    }
}

