/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.ConditionallyActive;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.entities.properties.conditionals.RequiresItems;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.ui.RequiredItemEntry;
import java.util.logging.Logger;

public class ItemIsActive
extends RequiresItems {
    Logger log = Logger.getLogger(ItemIsActive.class.getName());

    @Override
    protected Array<Item> getPotentialItems(MapScreen map) {
        Array<Item> potentialItems = new Array<Item>();
        map.grid.items.forEach((_id, item) -> {
            if (item.hasProperty(PropertyType.ConditionallyActive)) {
                potentialItems.add((Item)item);
            }
        });
        return potentialItems;
    }

    @Override
    protected String getEmptyMessage() {
        return "No Conditionally active items on the map";
    }

    @Override
    public boolean evaluate(GameContext ctx) {
        for (RequiredItemEntry.RequiredItem ri : this.items) {
            Item i = ri.getItem();
            ConditionallyActive cap = i.getProperty(PropertyType.ConditionallyActive, ConditionallyActive.class).get();
            boolean valid = cap.isValid(ctx);
            this.log.fine("evaluating ItemIsActive for" + i.getItemName() + " (ID: " + i.getID() + ") -> evaluted as " + valid);
            if (valid) continue;
            this.log.fine("-> early return for evaluate");
            return false;
        }
        return true;
    }

    @Override
    public ConditionalType getType() {
        return ConditionalType.ItemIsActive;
    }

    @Override
    public String getName() {
        return "Item is Active";
    }
}

