/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.ConnectorSink;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.entities.properties.conditionals.RequiresItems;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.ui.RequiredItemEntry;

public class ItemsArePowered
extends RequiresItems {
    @Override
    protected Array<Item> getPotentialItems(MapScreen map) {
        Array<Item> potentialItems = new Array<Item>();
        map.grid.items.forEach((_id, item) -> {
            if (item.hasProperty(PropertyType.ConnectorSink)) {
                potentialItems.add((Item)item);
            }
        });
        return potentialItems;
    }

    @Override
    protected String getEmptyMessage() {
        return "No connector sinks on the map!";
    }

    @Override
    public boolean evaluate(GameContext ctx) {
        for (RequiredItemEntry.RequiredItem i : this.items) {
            boolean isPowered = i.getItem().getProperty(PropertyType.ConnectorSink, ConnectorSink.class).get().isConnected();
            if (i.getRequired().matches(isPowered)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ConditionalType getType() {
        return ConditionalType.ItemsArePowered;
    }

    @Override
    public String getName() {
        return "Item is powered";
    }
}

