/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.Toggleable;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.entities.properties.conditionals.RequiresItems;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.ui.RequiredItemEntry;
import java.util.logging.Logger;

public class ItemsAreToggled
extends RequiresItems {
    Logger log = Logger.getLogger(ItemsAreToggled.class.getName());

    @Override
    public boolean evaluate(GameContext ctx) {
        for (RequiredItemEntry.RequiredItem i : this.items) {
            boolean isToggled = i.getItem().getProperty(PropertyType.Toggleable, Toggleable.class).get().isToggled();
            if (i.getRequired().matches(isToggled)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ConditionalType getType() {
        return ConditionalType.ItemsAreToggled;
    }

    @Override
    protected Array<Item> getPotentialItems(MapScreen map) {
        Array<Item> potentialItems = new Array<Item>();
        map.grid.items.forEach((_id, item) -> {
            if (item.hasProperty(PropertyType.Toggleable)) {
                potentialItems.add((Item)item);
            }
        });
        return potentialItems;
    }

    @Override
    protected String getEmptyMessage() {
        return "No Toggleable Items on the map";
    }

    @Override
    public String getName() {
        return "Items are toggled";
    }
}

