/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.properties.conditionals.Conditional;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.screens.LevelEditorScreen;
import java.util.Optional;

public abstract class KaryConditional
extends Conditional {
    protected Array<Conditional> children = new Array();

    @Override
    public boolean requiresPoll() {
        boolean needsPoll = false;
        for (Conditional c : this.children) {
            if (!c.requiresPoll()) continue;
            needsPoll = true;
        }
        return needsPoll;
    }

    @Override
    public boolean poll(GameContext ctx) {
        boolean shouldPoll = false;
        for (Conditional c : this.children) {
            if (!c.poll(ctx)) continue;
            shouldPoll = true;
        }
        return shouldPoll;
    }

    @Override
    public void write(Json json) {
        json.writeArrayStart("children");
        for (Conditional c : this.children) {
            json.writeObjectStart();
            json.writeValue("type", (Object)c.getType());
            c.write(json);
            json.writeObjectEnd();
        }
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        JsonValue arr = jsonData.get("children");
        for (JsonValue v : arr) {
            this.children.add(this.readCond(v));
        }
    }

    private Conditional readCond(JsonValue data) {
        String type = data.getString("type");
        ConditionalType t = ConditionalType.valueOf(type);
        Conditional c = t.getConditional();
        c.read(new Json(), data);
        return c;
    }

    @Override
    public Array<Conditional> getChildren() {
        return this.children;
    }

    public Optional<Actor> getEditorConfiguration(LevelEditorScreen editor) {
        return Optional.empty();
    }

    @Override
    public Optional<Integer> childCount() {
        return Optional.empty();
    }

    @Override
    public void setChildren(Conditional ... conds) {
        this.children.clear();
        this.children.addAll((Conditional[])conds);
    }
}

