/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.Grid;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.conditionals.Conditional;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.ItemSelectUI;
import java.util.Optional;
import java.util.logging.Logger;

public class PlayerHasItem
extends Conditional {
    ItemSelectUI.SelectedItem item = new ItemSelectUI.SelectedItem();
    Logger log = Logger.getLogger(PlayerHasItem.class.getName());

    @Override
    public boolean evaluate(GameContext ctx) {
        if (this.item.getItem() != null) {
            return ctx.player.getInventory().contains(this.item.getItem(), false);
        }
        return false;
    }

    @Override
    public void write(Json json) {
        json.writeValue("item_id", this.item.getItem() == null ? -1 : this.item.getItem().getID());
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        int i = jsonData.getInt("item_id", -1);
        Grid.onMapCompletion.add(grid -> {
            if (i != -1) {
                this.item = new ItemSelectUI.SelectedItem(grid.items.get(i));
            }
            return null;
        });
    }

    public Optional<Actor> getEditorConfiguration(LevelEditorScreen editor) {
        Array<Item> potentialItems = new Array<Item>();
        editor.grid.items.forEach((_id, item) -> {
            if (item.hasProperty(PropertyType.Obtainable)) {
                potentialItems.add((Item)item);
            }
        });
        return Optional.of(new ItemSelectUI(potentialItems, this.item, "No obtainable items currently on the grid", editor));
    }

    @Override
    public ConditionalType getType() {
        return ConditionalType.PlayerHasItem;
    }

    @Override
    public String getName() {
        return "Player has item";
    }
}

