/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.Grid;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.conditionals.Conditional;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.ui.RequireItemsUI;
import group24.escaperoom.ui.RequiredItemEntry;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import java.util.Optional;

public abstract class RequiresItems
extends Conditional {
    Array<RequiredItemEntry.RequiredItem> items = new Array();

    public void removeStaleItems() {
        Array<RequiredItemEntry.RequiredItem> newArr = new Array<RequiredItemEntry.RequiredItem>();
        for (RequiredItemEntry.RequiredItem item : this.items) {
            if (!Grid.current().items.containsKey(item.getItem().getID())) continue;
            newArr.add(item);
        }
        this.items = newArr;
    }

    @Override
    public void write(Json json) {
        this.removeStaleItems();
        json.writeArrayStart("items");
        this.items.forEach(i -> {
            json.writeObjectStart();
            json.writeValue("id", i.getItem().getID());
            json.writeValue("required", i.getRequired().name());
            json.writeObjectEnd();
        });
        json.writeArrayEnd();
    }

    protected abstract Array<Item> getPotentialItems(MapScreen var1);

    protected abstract String getEmptyMessage();

    public Optional<Actor> getEditorConfiguration(LevelEditorScreen stage) {
        this.removeStaleItems();
        Array<Item> potentialItems = this.getPotentialItems(stage);
        if (potentialItems.isEmpty()) {
            return Optional.of(new EmptyMessage(this.getEmptyMessage()));
        }
        return Optional.of(new RequireItemsUI(potentialItems, this.items, stage));
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        JsonValue items = jsonData.get("items");
        Grid.onMapCompletion.add(grid -> {
            if (items != null) {
                items.forEach(tij -> {
                    Item item = grid.items.get(tij.getInt("id"));
                    RequiredItemEntry.ItemRequired typeRequired = RequiredItemEntry.ItemRequired.valueOf(tij.getString("required"));
                    RequiredItemEntry.RequiredItem ti = new RequiredItemEntry.RequiredItem(item, typeRequired);
                    this.items.add(ti);
                });
            }
            return null;
        });
    }

    private class EmptyMessage
    extends SmallLabel
    implements ConfigurationMenu.HandlesMenuClose {
        EmptyMessage(String msg) {
            super(msg);
        }

        @Override
        public void handle() {
        }
    }
}

