/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.properties.conditionals.Conditional;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.entities.properties.conditionals.KaryConditional;

public class SequenceConditional
extends KaryConditional {
    int nextStage = 0;
    State state = State.Progressing;

    @Override
    public boolean evaluate(GameContext ctx) {
        return this.state == State.Completed;
    }

    private void progress(GameContext ctx) {
        for (int i = 0; i < this.children.size; ++i) {
            if (((Conditional)this.children.get(i)).evaluate(ctx)) {
                if (i == this.nextStage) {
                    this.nextStage = i + 1;
                    break;
                }
                if (i <= this.nextStage) continue;
                this.state = State.NeedsReset;
                return;
            }
            if (i >= this.nextStage) continue;
            this.state = State.NeedsReset;
            return;
        }
        if (this.nextStage >= this.children.size) {
            this.state = State.Completed;
        }
    }

    private void tryReset(GameContext ctx) {
        boolean canReset = true;
        for (Conditional c : this.children) {
            if (!c.evaluate(ctx)) continue;
            canReset = false;
        }
        if (canReset) {
            this.nextStage = 0;
            this.state = State.Progressing;
        }
    }

    @Override
    public boolean poll(GameContext ctx) {
        this.children.forEach(c -> c.poll(ctx));
        switch (this.state) {
            case Completed: {
                return false;
            }
            case NeedsReset: {
                this.tryReset(ctx);
                break;
            }
            case Progressing: {
                this.progress(ctx);
            }
        }
        return true;
    }

    @Override
    public boolean requiresPoll() {
        return true;
    }

    @Override
    public ConditionalType getType() {
        return ConditionalType.SequenceConditional;
    }

    @Override
    public String getName() {
        return "In Sequence...";
    }

    public static enum State {
        Progressing,
        NeedsReset,
        Completed;

    }
}

