/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.entities.properties.conditionals;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.properties.conditionals.Conditional;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.entities.properties.conditionals.EmptyConditional;
import group24.escaperoom.screens.LevelEditorScreen;
import java.util.Optional;

public abstract class UnaryConditional
extends Conditional {
    Conditional child = new EmptyConditional();

    @Override
    public boolean requiresPoll() {
        return this.child.requiresPoll();
    }

    @Override
    public boolean poll(GameContext ctx) {
        return this.child.poll(ctx);
    }

    @Override
    public void write(Json json) {
        json.writeObjectStart("child");
        json.writeValue("type", (Object)this.child.getType());
        this.child.write(json);
        json.writeObjectEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        JsonValue data = jsonData.get("child");
        String type = data.getString("type");
        ConditionalType t = ConditionalType.valueOf(type);
        Conditional c = t.getConditional();
        c.read(new Json(), data);
        this.child = c;
    }

    @Override
    public void setChildren(Conditional ... conds) {
        if (conds.length > 0) {
            this.child = conds[0];
        }
    }

    @Override
    public Array<Conditional> getChildren() {
        return Array.with(this.child);
    }

    @Override
    public Optional<Integer> childCount() {
        return Optional.of(1);
    }

    public Optional<Actor> getEditorConfiguration(LevelEditorScreen editor) {
        return Optional.empty();
    }
}

