/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.lwjgl3;

import com.badlogic.gdx.tools.texturepacker.TexturePacker;
import java.io.File;

public class AtlasBuilder {
    private static boolean needsBuild(File textureDir, String atlasPath) {
        File atlasFile = new File(atlasPath);
        if (!atlasFile.exists()) {
            return true;
        }
        for (File f : textureDir.listFiles()) {
            if (f.lastModified() <= atlasFile.lastModified()) continue;
            return true;
        }
        return false;
    }

    public static void buildAtlas() {
        String atlasPath;
        File textureDir = new File("textures/entity_textures");
        File atlasDir = new File("texture_atlas");
        if (!atlasDir.exists() && !atlasDir.mkdir()) {
            System.out.println("Failed to create atlas dir... exiting");
            System.exit(1);
        }
        if (!textureDir.exists()) {
            System.out.println("Texture path (" + textureDir.getPath() + ") does not exist...exiting");
            System.exit(1);
        }
        if (!AtlasBuilder.needsBuild(textureDir, atlasPath = atlasDir.getAbsolutePath() + "/textureAtlas.atlas")) {
            return;
        }
        TexturePacker.Settings settings = new TexturePacker.Settings();
        settings.paddingX = 0;
        settings.paddingY = 0;
        settings.bleed = false;
        TexturePacker.process(settings, textureDir.getAbsolutePath(), atlasDir.getAbsolutePath(), "textureAtlas");
    }
}

