/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FillViewport;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import group24.escaperoom.AssetManager;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.data.NotificationBus;
import group24.escaperoom.entities.Poll;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.ui.NotificationOverlay;
import java.util.HashSet;
import java.util.Optional;

public abstract class AbstractScreen
extends Stage
implements Screen {
    public static final int SCREEN_WIDTH = 1920;
    public static final int SCREEN_HEIGHT = 1080;
    public static final int WORLD_WIDTH = 48;
    public static final int WORLD_HEIGHT = 27;
    public static final Skin skin = new Skin(Gdx.files.internal("group24/skin/skin.json"));
    protected InputMultiplexer inputPlex;
    protected FillViewport fillView;
    private NotificationOverlay overlay;
    private Stage uiStage;
    protected Optional<Actor> followActor;
    private final HashSet<Poll> pollables = new HashSet();
    protected final SpriteBatch spriteBatch;
    protected final HashSet<RenderSprite> sprites = new HashSet();

    public NotificationOverlay getNotificationOverlay() {
        return this.overlay;
    }

    protected AbstractScreen() {
        super(new FillViewport(48.0f, 27.0f, new OrthographicCamera()));
        this.uiStage = new Stage(new ScreenViewport());
        this.overlay = new NotificationOverlay();
        this.uiStage.addActor(this.overlay);
        this.fillView = new FillViewport(48.0f, 27.0f, new OrthographicCamera());
        this.inputPlex = new InputMultiplexer();
        this.spriteBatch = new SpriteBatch();
        this.followActor = Optional.empty();
        AssetManager.instance().update();
        AssetManager.instance().finishLoading();
        ControlsManager.clearRegisteredInputs();
        BackManager.clearActions();
        BackManager.setOwner(this);
    }

    protected void init() {
    }

    @Override
    public void resize(int width, int height) {
        this.getViewport().update(width, height);
        this.uiStage.getViewport().update(width, height, true);
        this.fillView.update(width, height);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        ControlsManager.processInputs();
        HashSet toRemove = new HashSet();
        this.pollables.forEach(p -> {
            if (!p.poll(delta)) {
                toRemove.add(p);
            }
        });
        this.pollables.removeAll(toRemove);
    }

    public void addPollable(Poll pollable) {
        this.pollables.add(pollable);
    }

    public void removePollable(Poll pollable) {
        this.pollables.remove(pollable);
    }

    protected void addSprite(Texture t, float x, float y, float width, float height) {
        this.sprites.add(new RenderSprite(t, x, y, width, height));
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f, true);
        this.spriteBatch.setProjectionMatrix(this.fillView.getCamera().combined);
        this.fillView.apply(true);
        if (!this.sprites.isEmpty()) {
            this.spriteBatch.begin();
            this.sprites.forEach(s -> ((RenderSprite)s).draw(this.spriteBatch));
            this.spriteBatch.end();
        }
        this.getViewport().apply();
        this.act(delta);
        this.followActor.ifPresent(actor -> this.getViewport().getCamera().position.set(actor.getX(1), actor.getY(1), this.getViewport().getCamera().position.z));
        this.draw();
        this.uiStage.getViewport().apply(true);
        this.uiStage.act(delta);
        this.uiStage.draw();
    }

    public void addUI(Actor actor) {
        this.uiStage.addActor(actor);
        this.overlay.toFront();
    }

    protected void addInputProcessor(InputProcessor ... processors) {
        for (InputProcessor proc : processors) {
            this.inputPlex.addProcessor(proc);
        }
    }

    public Stage getUIStage() {
        return this.uiStage;
    }

    @Override
    public void show() {
        this.init();
        this.inputPlex.addProcessor(this.uiStage);
        this.inputPlex.addProcessor(this);
        Gdx.input.setInputProcessor(this.inputPlex);
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    public Vector2 UIcoordToGame(Vector2 uiCoords) {
        return this.screenToStageCoordinates(this.uiStage.stageToScreenCoordinates(uiCoords));
    }

    public Vector2 gameCoordToUI(Vector2 gameCoords) {
        return this.uiStage.screenToStageCoordinates(this.stageToScreenCoordinates(gameCoords));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.uiStage.dispose();
        NotificationBus.get().removeListener(this.overlay);
    }

    private class RenderSprite {
        private Texture t;
        private float x;
        private float y;
        private float w;
        private float h;

        RenderSprite(Texture t, float x, float y, float w, float h) {
            this.t = t;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        private void draw(SpriteBatch b) {
            b.draw(this.t, this.x, this.y, this.w, this.h);
        }
    }
}

