/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.Input;
import group24.escaperoom.screens.AbstractScreen;
import java.util.Stack;

public class BackManager {
    private static Stack<PossibleBackAction> backActions;
    private static AbstractScreen owner;
    private static BackAction onEmpty;

    public static void setOwner(AbstractScreen screen) {
        owner = screen;
    }

    public static void clearActions() {
        backActions.clear();
        onEmpty = null;
    }

    public static void setOnEmpty(BackAction action) {
        onEmpty = action;
    }

    public static void addBack(BackAction action) {
        BackManager.addBack(() -> {
            action.onBack();
            return true;
        });
    }

    public static void addBack(PossibleBackAction action) {
        backActions.add(action);
    }

    public static void goBack() {
        PossibleBackAction backAction;
        if (owner == null) {
            return;
        }
        if (backActions.empty() && onEmpty != null) {
            onEmpty.onBack();
            return;
        }
        if (backActions.size() > 0 && !(backAction = backActions.pop()).onBack()) {
            BackManager.goBack();
        }
    }

    static {
        ControlsManager.registerPermanentInput(Input.BACK, ControlsManager.InputType.PRESSED, BackManager::goBack);
        backActions = new Stack();
    }

    public static interface BackAction {
        public void onBack();
    }

    public static interface PossibleBackAction {
        public boolean onBack();
    }
}

