/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import group24.escaperoom.AssetManager;

public class CursorManager {
    private static CursorType cur;
    public static final CursorType DEFAULT;

    public static void setCursor(CursorType type) {
        cur = type;
        AssetManager.instance().load(type.asset, Pixmap.class);
        AssetManager.instance().finishLoading();
        Pixmap cursorPixmap = (Pixmap)AssetManager.instance().get(type.asset);
        Cursor cursor = Gdx.graphics.newCursor(cursorPixmap, type.hotSpotX, type.hotSpotY);
        Gdx.graphics.setCursor(cursor);
    }

    public static InputListener hoverHelper(final CursorType type) {
        return new InputListener(){
            boolean dragging = false;

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return false;
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (cur == DEFAULT && pointer == -1) {
                    CursorManager.setCursor(type);
                }
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                if (pointer >= 0) {
                    this.dragging = true;
                }
                if (pointer == -1 && !this.dragging && cur == type) {
                    CursorManager.restoreDefault();
                }
            }
        };
    }

    public static void restoreDefault() {
        CursorManager.setCursor(DEFAULT);
    }

    static {
        DEFAULT = CursorType.Pointer;
    }

    public static enum CursorType {
        Brush("brush_cursor.png", 16, 16),
        Delete("delete_cursor.png", 0, 0),
        Fill("fill_cursor.png", 0, 0),
        Hand("hand_cursor.png", 16, 16),
        Move("move_cursor.png", 0, 0),
        Pointer("cursor.png", 0, 0),
        Rotate("rotate_cursor.png", 0, 0),
        Select("select_cursor.png", 16, 16),
        CopyPaste("copy_cursor.png", 0, 0),
        EyeDrop("eyedrop_cursor.png", 0, 31),
        InvalidCopyPaste("invalid_copy_cursor.png", 0, 0),
        InvalidMove("invalid_move_cursor.png", 0, 0);

        String asset;
        int hotSpotX;
        int hotSpotY;

        private CursorType(String asset, int hotSpotX, int hotSpotY) {
            this.asset = "textures/" + asset;
            this.hotSpotX = hotSpotX;
            this.hotSpotY = hotSpotY;
        }
    }
}

