/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.AssetManager;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.Input;
import group24.escaperoom.data.Drawable;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.GameStatistics;
import group24.escaperoom.data.MapData;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.FowTile;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.Player;
import group24.escaperoom.entities.properties.ConditionallyActive;
import group24.escaperoom.entities.properties.ConditionallyVisible;
import group24.escaperoom.entities.properties.Connectable;
import group24.escaperoom.entities.properties.InteractableProperty;
import group24.escaperoom.entities.properties.LockedProperty;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.TiledBrushable;
import group24.escaperoom.screens.ActionLog;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.ui.GameSettingsDialog;
import group24.escaperoom.ui.PlayerInventoryItemSlot;
import group24.escaperoom.ui.dnd.ItemPayload;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.widgets.G24Dialog;
import group24.escaperoom.utils.Collisions;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Logger;

public abstract class GameScreen
extends MapScreen {
    protected GameType gameType;
    private Logger log = Logger.getLogger(GameScreen.class.getName());
    private Item inFlightItem = null;
    private DragAndDrop dragAndDrop = new DragAndDrop();
    public static Player player;
    public int playerId = -1;
    protected ActionLog actionlog;
    boolean[][] revealed;
    FowTile[][] fowTiles;
    protected Table rootTable;
    public GameStatistics stats = new GameStatistics();
    private long startTime;

    public ActionLog getActionLog() {
        return this.actionlog;
    }

    public GameType getGameType() {
        return this.gameType;
    }

    public DragAndDrop getDragAndDrop() {
        return this.dragAndDrop;
    }

    private void resetRevealed() {
        for (int y = 0; y < this.gridSize.height; ++y) {
            for (int x = 0; x < this.gridSize.width; ++x) {
                if (!this.revealed[y][x]) continue;
                this.revealed[y][x] = false;
                this.fowTiles[y][x].updateTiles(this.revealed, new Vector2(x, y), true);
            }
        }
    }

    public GameScreen(MapData mapdata) {
        super(mapdata);
        this.revealed = new boolean[this.gridSize.height][this.gridSize.width];
        this.fowTiles = new FowTile[this.gridSize.height][this.gridSize.width];
        for (int y = 0; y < this.gridSize.height; ++y) {
            for (int x = 0; x < this.gridSize.width; ++x) {
                this.fowTiles[y][x] = new FowTile();
            }
        }
        FowTile.fowTiles = this.fowTiles;
        FowTile.gridSize = this.gridSize;
        AssetManager.instance().load("textures/game_tile.png", Texture.class);
        AssetManager.instance().finishLoading();
        Texture tile = AssetManager.instance().get("textures/game_tile.png", Texture.class);
        tile.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        TextureRegion roomTexture = new TextureRegion(tile);
        roomTexture.setRegion(0, 0, tile.getWidth() * this.gridSize.width, tile.getHeight() * this.gridSize.height);
        this.room.remove();
        this.room = new Image(roomTexture);
        this.room.setName("room");
        this.room.setPosition(0.0f, 0.0f);
        this.room.setSize(this.gridSize.width, this.gridSize.height);
        this.addActor(this.room);
        this.startTime = System.currentTimeMillis();
        player = new Player(this.gridSize.width / 2, this.gridSize.height / 2, this);
        player.registerBinds();
        this.rootTable = new Table();
        this.rootTable.setPosition(0.0f, 0.0f);
        this.rootTable.setFillParent(true);
        this.rootTable.bottom().left();
        this.rootTable.defaults().pad(10.0f);
        this.getUIStage().addActor(this.rootTable);
        this.actionlog = new ActionLog();
        this.rootTable.add(this.actionlog).left().bottom().size(300.0f, 150.0f);
        this.actionlog.emit("Game Started...");
        this.registerBinds();
        for (int y = 0; y < this.gridSize.height; ++y) {
            for (int x = 0; x < this.gridSize.width; ++x) {
                this.revealed[y][x] = false;
            }
        }
        this.dragAndDrop.addTarget(new GameMapTarget(this.roomProxy));
    }

    public void calculateStatistics(boolean completedSucessfully) {
        long finishTime = System.currentTimeMillis();
        this.stats.timeMilliseconds = finishTime - this.startTime;
        this.stats.completedSucessfully = completedSucessfully;
        player.calculateStatistics(this.stats);
    }

    private Optional<Item> priorityItemAt(int x, int y) {
        Optional<Item[]> maybeItems = this.getItemsAt(x, y);
        if (maybeItems.isEmpty()) {
            return Optional.empty();
        }
        Item[] items = maybeItems.get();
        if (items.length == 0) {
            return Optional.empty();
        }
        Optional<Item> focusedItem = player.getFocusedItem();
        if (focusedItem.isPresent()) {
            Item item = focusedItem.get();
            for (int i = 0; i < items.length; ++i) {
                if (items[i].getID() != item.getID()) continue;
                return Optional.of(items[i]);
            }
        }
        int maxRender = Integer.MIN_VALUE;
        Item item = null;
        Array<Item> focusCanidates = player.getFocusCanidates();
        for (int i = 0; i < items.length; ++i) {
            if (!focusCanidates.contains(items[i], false) || items[i].renderPriority() <= maxRender) continue;
            item = items[i];
            maxRender = items[i].renderPriority();
        }
        if (item == null) {
            return Optional.empty();
        }
        return Optional.of(item);
    }

    private boolean collidesMenu(Vector2 uiPos) {
        for (Actor a : this.getUIStage().getRoot().getChildren()) {
            Window m;
            Rectangle bounds;
            if (!(a instanceof Menu ? (bounds = new Rectangle((m = (Menu)a).getX(), m.getY(), m.getWidth(), m.getHeight())).contains(uiPos) : a instanceof G24Dialog && (bounds = new Rectangle((m = (G24Dialog)a).getX(), m.getY(), m.getWidth(), m.getHeight())).contains(uiPos))) continue;
            return true;
        }
        return false;
    }

    private void registerBinds() {
        ControlsManager.registerInput(Input.ZOOM_OUT, ControlsManager.InputType.HELD, () -> {
            this.cameraManager.zoomOut();
            this.updateProxy();
        });
        ControlsManager.registerInput(Input.ZOOM_IN, ControlsManager.InputType.HELD, () -> {
            this.cameraManager.zoomIn();
            this.updateProxy();
        });
        ControlsManager.registerInput(Input.SELECT, ControlsManager.InputType.PRESSED, () -> {
            Vector2 screenPos = new Vector2(Gdx.input.getX(), Gdx.input.getY());
            Vector2 uiPos = this.getUIStage().screenToStageCoordinates(screenPos.cpy());
            if (this.collidesMenu(uiPos)) {
                return;
            }
            Vector2 position = this.screenToStageCoordinates(screenPos);
            this.priorityItemAt((int)position.x, (int)position.y).ifPresent(pi -> {
                player.getFocusedItem().ifPresent(fi -> fi.setFocus(false));
                pi.setFocus(true);
                pi.getProperty(PropertyType.Interactable, InteractableProperty.class).get().interact(new GameContext(this, player));
            });
        });
        BackManager.setOnEmpty(() -> {
            GameSettingsDialog gsd = new GameSettingsDialog(this);
            gsd.show(this.getUIStage());
        });
    }

    @Override
    public void act(float time) {
        player.act(time);
        GameContext ctx = new GameContext(this, player);
        for (Item item : this.pollItems) {
            item.getProperty(PropertyType.ConditionallyActive, ConditionallyActive.class).ifPresent(cap -> {
                if (!cap.poll(ctx)) {
                    this.pollItems.removeValue(item, false);
                }
            });
            item.getProperty(PropertyType.ConditionallyVisible, ConditionallyVisible.class).ifPresent(cvp -> cvp.poll(ctx));
        }
        super.act(time);
        if (!this.metadata.gameSettings.persistentReveal) {
            this.resetRevealed();
        }
        Rectangle hitbox = player.getOccupiedRegion();
        this.reveal((int)(hitbox.x + hitbox.width / 2.0f), (int)hitbox.y);
    }

    public void reveal(int x, int y) {
        if (y < 0 || x < 0 || y >= this.gridSize.height || x >= this.gridSize.width) {
            return;
        }
        int numRays = 360;
        for (float angle = 0.0f; angle < (float)numRays; angle += 1.0f) {
            float radians = (float)Math.PI / 180 * angle;
            float dx = MathUtils.cos(radians);
            float dy = MathUtils.sin(radians);
            this.castRay(x, y, dx, dy, 15);
        }
    }

    private boolean shouldBlockRay(Item item) {
        if (item.hasProperty(PropertyType.Barrier)) {
            LockedProperty prop;
            return !item.hasProperty(PropertyType.LockedProperty) || (prop = item.getProperty(PropertyType.LockedProperty, LockedProperty.class).get()).isLocked();
        }
        return false;
    }

    private void castRay(int x, int y, float dx, float dy, int maxDistance) {
        Types.IntVector2 tl = new Types.IntVector2();
        Types.IntVector2 tr = new Types.IntVector2();
        Types.IntVector2 bl = new Types.IntVector2();
        Types.IntVector2 br = new Types.IntVector2();
        TreeSet<Types.IntVector2> tiles = new TreeSet<Types.IntVector2>(new Comparator<Types.IntVector2>(){

            @Override
            public int compare(Types.IntVector2 arg0, Types.IntVector2 arg1) {
                if (arg0.equals(arg1)) {
                    return 0;
                }
                if (arg0.x != arg1.x) {
                    return arg0.x - arg1.x;
                }
                return arg0.y - arg1.y;
            }
        });
        float newX = (float)x + 0.5f;
        float newY = (float)y + 0.5f;
        for (int i = 0; i < maxDistance; ++i) {
            int tileX = MathUtils.floor(newX);
            int tileY = MathUtils.floor(newY);
            if (tileY < 0 || tileX < 0 || tileY >= this.gridSize.height || tileX >= this.gridSize.width) break;
            Optional<Item[]> oItems = this.getItemsAt(tileX, tileY);
            if (oItems.isPresent()) {
                for (Item item : oItems.get()) {
                    if (!this.shouldBlockRay(item)) continue;
                    return;
                }
            }
            if (!this.revealed[tileY][tileX]) {
                this.revealTile(tileX, tileY);
            }
            float tmpX = newX + dx;
            float tmpY = newY + dy;
            tl.set(newX, newY);
            tr.set(newX, tmpY);
            bl.set(tmpX, newY);
            br.set(tmpX, tmpY);
            tiles.clear();
            tiles.add(tl);
            tiles.add(tr);
            tiles.add(bl);
            tiles.add(br);
            for (Types.IntVector2 tile : tiles) {
                Optional<Item[]> items = this.getItemsAt(tile);
                if (items.isEmpty()) continue;
                for (Item item : items.get()) {
                    if (!this.shouldBlockRay(item)) continue;
                    return;
                }
            }
            newX = tmpX;
            newY = tmpY;
        }
    }

    private void revealTile(int x, int y) {
        this.revealed[y][x] = true;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (Math.abs(dx) == Math.abs(dy)) continue;
                int cX = x + dx;
                int cY = y + dy;
                if (cX < 0 || cX >= this.gridSize.width || cY < 0 || cY >= this.gridSize.height) continue;
                this.fowTiles[cY][cX].updateTiles(this.revealed, new Vector2(cX, cY), true);
            }
        }
    }

    @Override
    public TreeSet<Drawable> getDrawables() {
        TreeSet<Drawable> drawables = this.grid.getDrawables();
        drawables.add(player);
        return drawables;
    }

    @Override
    public void draw() {
        super.draw(false);
        for (int y = 0; y < this.gridSize.height; ++y) {
            for (int x = 0; x < this.gridSize.width; ++x) {
                if (this.revealed[y][x]) continue;
                this.batch.draw(this.fowTiles[y][x].texture, (float)x, (float)y, 1.0f, 1.0f);
            }
        }
        if (this.inFlightItem != null) {
            this.inFlightItem.draw(this.batch);
        }
        this.batch.end();
    }

    public Array<Item> itemsNear(Circle circle) {
        Array<Item> ret = new Array<Item>();
        for (Item item : this.grid.placedItems.values()) {
            if (!Collisions.collides(circle, item.getOccupiedRegion())) continue;
            ret.add(item);
        }
        return ret;
    }

    public Array<Item> itemsNear(Vector2 center, float radius) {
        return this.itemsNear(new Circle(center.x, center.y, radius));
    }

    public static enum GameType {
        Standard,
        Editor,
        Verifying;

    }

    private class GameMapTarget
    extends DragAndDrop.Target {
        GameMapTarget(Actor proxy) {
            super(proxy);
        }

        @Override
        public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            Types.IntVector2 gameCoords = Types.IntVector2.fromVector2(GameScreen.this.getViewport().unproject(new Vector2(Gdx.input.getX(), Gdx.input.getY())));
            if (!gameCoords.contained(0, 0, GameScreen.this.gridSize.width - 1, GameScreen.this.gridSize.height - 1)) {
                return false;
            }
            if (!GameScreen.this.revealed[gameCoords.y][gameCoords.x]) {
                return false;
            }
            if (player.getCenter().dst(gameCoords.asVector2()) > 4.0f) {
                return false;
            }
            if (!(source instanceof PlayerInventoryItemSlot.PlayerInventorySource)) {
                return false;
            }
            Item item = ((ItemPayload)payload).getItem();
            if (GameScreen.this.inFlightItem == null) {
                GameScreen.this.inFlightItem = item;
                GameScreen.this.inFlightItem.setAlpha(0.75f);
            }
            if (GameScreen.this.canPlace(item, gameCoords)) {
                GameScreen.this.inFlightItem.setPosition(gameCoords.x, gameCoords.y);
                return true;
            }
            return false;
        }

        @Override
        public void reset(DragAndDrop.Source source, DragAndDrop.Payload payload) {
            if (GameScreen.this.inFlightItem == null) {
                return;
            }
            GameScreen.this.inFlightItem.setAlpha(1.0f);
            GameScreen.this.inFlightItem.remove(false);
            GameScreen.this.inFlightItem = null;
        }

        @Override
        public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            if (GameScreen.this.inFlightItem == null) {
                return;
            }
            GameScreen.this.inFlightItem.setContained(false);
            GameScreen.this.inFlightItem.setAlpha(1.0f);
            Types.IntVector2 gameCoords = Types.IntVector2.fromVector2(GameScreen.this.getViewport().unproject(new Vector2(Gdx.input.getX(), Gdx.input.getY())));
            if (GameScreen.this.canPlace(GameScreen.this.inFlightItem, gameCoords)) {
                GameScreen.this.inFlightItem.moveTo(gameCoords.x, gameCoords.y);
                GameScreen.this.grid.placeItem(GameScreen.this.inFlightItem);
            }
            Connectable.Utils.maybeUpateSurroundingTileables(GameScreen.this.inFlightItem, GameScreen.this);
            GameScreen.this.inFlightItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tbp -> tbp.refreshAdjacency(GameScreen.this));
            GameScreen.this.inFlightItem = null;
        }
    }
}

