/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.data.GameStatistics;
import group24.escaperoom.data.MapData;
import group24.escaperoom.data.MapLoader;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.MapSaver;
import group24.escaperoom.data.MapUploader;
import group24.escaperoom.data.Networking;
import group24.escaperoom.data.User;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.GameScreen;
import group24.escaperoom.screens.MapSelectScreen;
import group24.escaperoom.screens.MenuScreen;
import group24.escaperoom.screens.SinglePlayerGameScreen;
import group24.escaperoom.ui.MapDescriptionDialog;
import group24.escaperoom.ui.StatTable;
import group24.escaperoom.ui.widgets.G24TextButton;
import group24.escaperoom.utils.Notifier;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class GameSummaryScreen
extends MenuScreen {
    private StatTable statTable;
    private GameScreen.GameType gameType;
    private MapMetadata previousMetadata;
    private GameStatistics stats;

    public GameSummaryScreen(GameStatistics stats, MapMetadata metadata, GameScreen.GameType from) {
        this.gameType = from;
        this.stats = stats;
        this.previousMetadata = metadata;
        this.statTable = new StatTable(stats);
        ScrollPane pane = new ScrollPane((Actor)this.statTable, skin, "transparent");
        HorizontalGroup buttonGroup = new HorizontalGroup();
        PlayAgainButton playAgainBtn = new PlayAgainButton();
        ContinueButton continueBtn = new ContinueButton();
        buttonGroup.expand().align(1).space(100.0f).pad(20.0f);
        buttonGroup.addActor(playAgainBtn);
        buttonGroup.addActor(continueBtn);
        if (from == GameScreen.GameType.Verifying && User.isLoggedIn()) {
            UploadButton uploadButton = new UploadButton();
            buttonGroup.addActor(uploadButton);
            if (!stats.completedSucessfully) {
                uploadButton.setDisabled(true);
            }
        }
        if (User.isLoggedIn() && !metadata.mapID.isEmpty() && from != GameScreen.GameType.Verifying) {
            buttonGroup.addActor(new UpvoteButton());
            buttonGroup.addActor(new DownvoteButton());
        }
        if (User.isLoggedIn() && !metadata.mapID.isEmpty()) {
            this.waitFor(this.sendUpdates(stats, metadata), (T code) -> {
                if (code != Networking.StatusCode.OK) {
                    Notifier.warn("Failed to upload stats, check your connection");
                } else {
                    Notifier.info("Successfully uploaded your attempt!");
                }
                return null;
            }, "Uploading your attempt");
        }
        this.rootTable.add(pane);
        this.rootTable.row();
        this.rootTable.add(buttonGroup).center().bottom().expand().pad(20.0f);
    }

    private CompletableFuture<Networking.StatusCode> sendUpdates(GameStatistics stats, MapMetadata metadata) {
        Array<MapMetadata.MapStats.ValidStats> statUpdates = new Array<MapMetadata.MapStats.ValidStats>();
        statUpdates.add(MapMetadata.MapStats.ValidStats.attempts);
        User.getRecord().update(stats, metadata);
        CompletableFuture<Networking.StatusCode> recordFuture = Networking.updatePlayerRecord(User.getRecord());
        CompletableFuture<Networking.StatusCode> updateFuture = Networking.updateMapStats(metadata.mapID, statUpdates);
        CompletableFuture<Networking.StatusCode> clearFuture = stats.completedSucessfully ? Networking.sendMapClear(metadata.mapID, stats.timeMilliseconds) : CompletableFuture.supplyAsync(() -> Networking.StatusCode.OK);
        CompletionStage requests = CompletableFuture.allOf(updateFuture, clearFuture, recordFuture).thenApply(__ -> {
            Networking.StatusCode updateStatus = (Networking.StatusCode)((Object)((Object)updateFuture.join()));
            Networking.StatusCode recordStatus = (Networking.StatusCode)((Object)((Object)recordFuture.join()));
            Networking.StatusCode clearStatus = (Networking.StatusCode)((Object)((Object)clearFuture.join()));
            if (updateStatus != Networking.StatusCode.OK) {
                System.err.println("update map stats failed");
                return updateStatus;
            }
            if (recordStatus != Networking.StatusCode.OK) {
                System.err.println("update player record failed");
                return recordStatus;
            }
            if (clearStatus != Networking.StatusCode.OK) {
                System.err.println("send map clear failed");
            }
            return clearStatus;
        });
        return requests;
    }

    private class PlayAgainButton
    extends G24TextButton {
        public PlayAgainButton() {
            super("Play Again");
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (PlayAgainButton.this.isChecked()) {
                        switch (GameSummaryScreen.this.gameType) {
                            case Editor: {
                                MapLoader.tryLoadMap(GameSummaryScreen.this.previousMetadata).ifPresent(m -> ScreenManager.instance().showScreen(new SinglePlayerGameScreen((MapData)m)));
                                break;
                            }
                            case Standard: {
                                MapLoader.tryLoadMap(GameSummaryScreen.this.previousMetadata).ifPresent(m -> ScreenManager.instance().showScreen(new SinglePlayerGameScreen((MapData)m, false)));
                                break;
                            }
                            case Verifying: {
                                MapLoader.tryLoadMap(GameSummaryScreen.this.previousMetadata).ifPresent(m -> ScreenManager.instance().showScreen(new SinglePlayerGameScreen((MapData)m, true)));
                                break;
                            }
                        }
                    }
                }
            });
        }
    }

    private class ContinueButton
    extends G24TextButton {
        public ContinueButton() {
            super("Continue");
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (ContinueButton.this.isChecked()) {
                        ScreenManager.instance().showScreen(new MapSelectScreen.MapSelectScreenBuilder(true).build());
                    }
                }
            });
        }
    }

    private class UploadButton
    extends G24TextButton {
        public UploadButton() {
            super("Upload");
            this.setProgrammaticChangeEvents(false);
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (UploadButton.this.isChecked()) {
                        UploadButton.this.setChecked(false);
                        new MapDescriptionDialog(desc -> {
                            ((GameSummaryScreen)GameSummaryScreen.this).previousMetadata.stats = Optional.of(MapMetadata.MapStats.fromGameStats(GameSummaryScreen.this.stats));
                            ((GameSummaryScreen)GameSummaryScreen.this).previousMetadata.stats.get().description = desc;
                            GameSummaryScreen.this.waitFor(MapUploader.uploadMap(GameSummaryScreen.this.previousMetadata), output -> {
                                output.reason.ifPresent(err -> Notifier.error(err));
                                output.response.ifPresent(rsp -> {
                                    Notifier.info(String.format("%s successfully uploaded!", ((GameSummaryScreen)GameSummaryScreen.this).previousMetadata.name));
                                    ((GameSummaryScreen)GameSummaryScreen.this).previousMetadata.mapID = rsp.mapID;
                                    if (!MapSaver.updateMetadata(GameSummaryScreen.this.previousMetadata)) {
                                        Notifier.warn(String.format("%s failed to update metadata!", ((GameSummaryScreen)GameSummaryScreen.this).previousMetadata.name));
                                    }
                                    UploadButton.this.setDisabled(true);
                                });
                                return null;
                            }, "Uploading");
                            return null;
                        }).show(UploadButton.this.getStage());
                    }
                }
            });
        }
    }

    private class UpvoteButton
    extends ImageButton {
        public UpvoteButton() {
            super(AbstractScreen.skin, "upvote");
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (UpvoteButton.this.isChecked()) {
                        UpvoteButton.this.setDisabled(true);
                        Networking.updateMapStats(((GameSummaryScreen)GameSummaryScreen.this).previousMetadata.mapID, Array.with(MapMetadata.MapStats.ValidStats.upvotes)).thenAccept(s -> Gdx.app.postRunnable(() -> {
                            if (s != Networking.StatusCode.OK) {
                                Notifier.error("Error sending upvote!");
                            }
                        }));
                    }
                }
            });
        }
    }

    private class DownvoteButton
    extends ImageButton {
        public DownvoteButton() {
            super(AbstractScreen.skin, "downvote");
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (DownvoteButton.this.isChecked()) {
                        DownvoteButton.this.setDisabled(true);
                        Networking.updateMapStats(((GameSummaryScreen)GameSummaryScreen.this).previousMetadata.mapID, Array.with(MapMetadata.MapStats.ValidStats.downvotes)).thenAccept(s -> Gdx.app.postRunnable(() -> {
                            if (s != Networking.StatusCode.OK) {
                                Notifier.error("Error sending downvote!");
                            }
                        }));
                    }
                }
            });
        }
    }
}

