/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.AssetManager;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.Input;
import group24.escaperoom.data.ItemSaver;
import group24.escaperoom.data.MapData;
import group24.escaperoom.data.MapLoader;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.MapSaver;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.objects.ObjectTypeData;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.screens.editor.CamMan;
import group24.escaperoom.ui.ConfirmDialog;
import group24.escaperoom.ui.editor.ItemSideBar;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.editor.PropertyBank;
import group24.escaperoom.ui.editor.PropertyConfigurationMenu;
import group24.escaperoom.ui.editor.PropertyWorkspace;
import group24.escaperoom.utils.Notifier;
import group24.escaperoom.utils.Types;
import java.util.HashMap;

public class ItemEditor
extends AbstractScreen {
    private Image room;
    protected final Batch batch = new SpriteBatch();
    private Item newItem;
    private Item originalItem;
    private MapData mapData;
    private boolean dirty = false;
    private CamMan cameraManager;
    private Texture background;
    private int ROOM_W = 9;
    private int ROOM_H = 9;
    private static final int BANK_HEIGHT = 300;
    private static final int BAR_WIDTH = 250;
    private Table rootTable = new Table();
    private DragAndDrop dragAndDrop;
    public Menu itemMenu;
    public ItemSideBar itemSidebar;
    static PropertyBank bank;
    static Container<Menu> itemMenuContainer;
    public static ItemEditor screen;
    private boolean modifyingItem;
    private PropertyConfigurationMenu configurationMenu;

    public Item getNewItem() {
        return this.newItem;
    }

    public DragAndDrop getDragAndDrop() {
        return this.dragAndDrop;
    }

    public static ItemEditor get() {
        return screen;
    }

    public void markModified() {
        this.dirty = true;
    }

    public ItemEditor(MapData data, @Null Item target) {
        screen = this;
        this.mapData = data;
        this.dragAndDrop = new DragAndDrop();
        this.cameraManager = new CamMan((OrthographicCamera)this.getViewport().getCamera());
        if (target == null) {
            this.modifyingItem = false;
            this.initEmptyItem();
        } else {
            this.modifyingItem = true;
            this.originalItem = target;
            this.originalItem.remove(true);
            this.newItem = this.originalItem.clone(true);
        }
        this.fillPropertyParams();
        this.addRoom();
        this.registerBinds();
        this.rootTable.defaults().pad(0.0f);
        this.rootTable.setFillParent(true);
        this.rootTable.top().left();
        this.itemMenu = new Menu(null, "Item Values", null);
        itemMenuContainer = new Container<Menu>(this.itemMenu);
        itemMenuContainer.top().left();
        this.itemSidebar = new ItemSideBar();
        this.itemMenu.add(this.itemSidebar).top().padRight(20.0f).padLeft(10.0f).growY().minWidth(250.0f);
        this.itemMenu.setMovable(false);
        AssetManager.instance().load("textures/menu_hover.png", Texture.class);
        AssetManager.instance().finishLoadingAsset("textures/menu_hover.png");
        Texture bkg = AssetManager.instance().get("textures/menu_hover.png", Texture.class);
        TextureRegionDrawable hoverBackground = new TextureRegionDrawable(new TextureRegion(bkg));
        itemMenuContainer.setBackground(hoverBackground);
        this.rootTable.add(itemMenuContainer).top().left().growY();
        bank = new PropertyBank();
        this.rootTable.add(bank).maxHeight(300.0f).bottom().left().growX().growY();
        this.itemSidebar.populateFor(this.newItem);
        this.addUI(this.rootTable);
        BackManager.setOnEmpty(() -> {
            if (this.modifyingItem) {
                this.returnToEditor();
            } else if (this.dirty) {
                new ConfirmDialog.Builder("Changes are not saved!").withButton("Continue Editing", () -> {}).cancelText("Discard Changes").onCancel(() -> {
                    ItemEditor.get().resetItem();
                    this.returnToEditor();
                }).confirmText("Save").onConfirm(() -> {
                    this.saveItem();
                    this.returnToEditor();
                }).build().show(this.getUIStage());
            } else {
                this.returnToEditor();
            }
        });
    }

    PropertyWorkspace.PropertyPill<?, ?> hitsPill(Vector2 uiCoords) {
        for (PropertyWorkspace.PropertyPill<?, ?> a : this.itemSidebar.workspace.getPills()) {
            Vector2 origin = a.localToStageCoordinates(new Vector2(0.0f, 0.0f));
            Rectangle bounds = new Rectangle(origin.x, origin.y, a.getWidth(), a.getHeight());
            if (!bounds.contains(uiCoords)) continue;
            return a;
        }
        return null;
    }

    public boolean mouseCollidesMenu() {
        float x = Gdx.input.getX();
        float y = Gdx.input.getY();
        Vector2 uiPos = this.getUIStage().screenToStageCoordinates(new Vector2(x, y));
        x = uiPos.x;
        y = uiPos.y;
        for (Actor a : this.getUIStage().getRoot().getChildren()) {
            Menu m;
            Rectangle bounds;
            if (!(a instanceof Menu) || !(bounds = new Rectangle((m = (Menu)a).getX(), m.getY(), m.getWidth(), m.getHeight())).contains(new Vector2(x, y))) continue;
            return true;
        }
        return false;
    }

    private void registerBinds() {
        this.addListener(new InputListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountseX, float amountY) {
                if (amountY < 0.0f) {
                    ItemEditor.this.cameraManager.zoomOut();
                } else if (amountY > 0.0f) {
                    ItemEditor.this.cameraManager.zoomIn();
                }
                return true;
            }

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!ItemEditor.this.mouseCollidesMenu() && ItemEditor.this.configurationMenu != null) {
                    ItemEditor.this.configurationMenu.close();
                    ItemEditor.this.configurationMenu = null;
                    return true;
                }
                return false;
            }
        });
        ControlsManager.registerInput(Input.CONTEXT, ControlsManager.InputType.PRESSED, () -> {
            Vector2 screenCoords = new Vector2(Gdx.input.getX(), Gdx.input.getY());
            Vector2 uiCoords = this.getUIStage().screenToStageCoordinates(screenCoords);
            PropertyWorkspace.PropertyPill<?, ?> pill = this.hitsPill(uiCoords);
            if (pill == null) {
                return;
            }
            this.configurationMenu = new PropertyConfigurationMenu((ItemProperty<? extends ItemPropertyValue>)pill.getProperty());
            this.configurationMenu.setPosition(uiCoords.x, uiCoords.y);
            this.addUI(this.configurationMenu);
            BackManager.addBack(() -> {
                if (this.configurationMenu == null || this.configurationMenu.getStage() == null) {
                    return false;
                }
                this.configurationMenu.close();
                this.configurationMenu = null;
                return true;
            });
        });
        ControlsManager.registerInput(Input.ZOOM_OUT, ControlsManager.InputType.HELD, () -> this.cameraManager.zoomOut());
        ControlsManager.registerInput(Input.ZOOM_IN, ControlsManager.InputType.HELD, () -> this.cameraManager.zoomIn());
        ControlsManager.registerInput(Input.MOVE_UP, ControlsManager.InputType.HELD, () -> this.cameraManager.translate(CamMan.Translation.Up));
        ControlsManager.registerInput(Input.MOVE_LEFT, ControlsManager.InputType.HELD, () -> this.cameraManager.translate(CamMan.Translation.Left));
        ControlsManager.registerInput(Input.MOVE_DOWN, ControlsManager.InputType.HELD, () -> this.cameraManager.translate(CamMan.Translation.Down));
        ControlsManager.registerInput(Input.MOVE_RIGHT, ControlsManager.InputType.HELD, () -> this.cameraManager.translate(CamMan.Translation.Right));
    }

    public void repack() {
        this.itemMenu.pack();
        itemMenuContainer.pack();
        bank.layout();
        this.rootTable.pack();
    }

    private void initEmptyItem() {
        ObjectTypeData blank = new ObjectTypeData("Blank", "None", new Types.Size(1, 1), "placeholder", 0, new HashMap<PropertyType, JsonValue>());
        this.newItem = new Item(blank);
    }

    private void addRoom() {
        AssetManager.instance().load("textures/tile.png", Texture.class);
        AssetManager.instance().finishLoading();
        Texture tile = AssetManager.instance().get("textures/tile.png", Texture.class);
        tile.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        TextureRegion roomTexture = new TextureRegion(tile);
        roomTexture.setRegion(0, 0, tile.getWidth() * this.ROOM_W, tile.getHeight() * this.ROOM_H);
        this.room = new Image(roomTexture);
        this.room.setSize(this.ROOM_W, this.ROOM_H);
        this.room.setName("room");
        if (this.room.getStage() == null) {
            this.addActor(this.room);
        }
        this.updateRoom();
        AssetManager.instance().load("textures/itemeditor_bkg.png", Texture.class);
        AssetManager.instance().finishLoading();
        this.background = AssetManager.instance().get("textures/itemeditor_bkg.png", Texture.class);
        this.addSprite(this.background, 0.0f, 0.0f, 48.0f, 27.0f);
    }

    public void resetItem() {
        if (this.modifyingItem) {
            this.newItem = this.originalItem.clone(true);
            this.fillPropertyParams();
        } else {
            this.initEmptyItem();
        }
        this.itemSidebar.populateFor(this.newItem);
        this.updateItemPosition();
    }

    public MapData getMapData() {
        return this.mapData;
    }

    private void transferProperties() {
        if (!this.modifyingItem) {
            return;
        }
        this.newItem.getProperties().forEach(newProp -> this.originalItem.getProperty(newProp.getType()).ifPresent(oldProp -> {
            Object val = oldProp.getCurrentValue();
            if (val != null) {
                newProp.unsafeSet((ItemPropertyValue)val);
                return;
            }
            Array<ItemPropertyValue> vals = oldProp.getCurrentValues();
            Array<ItemPropertyValue> downCastVals = new Array<ItemPropertyValue>();
            vals.forEach(v -> downCastVals.add((ItemPropertyValue)v));
            newProp.unsafeSet(downCastVals);
        }));
    }

    public void returnToEditor() {
        MapLoader.get(this.mapData.getMetadata().locations).ifPresent(metadata -> this.mapData.setMetadata((MapMetadata)metadata));
        if (this.modifyingItem) {
            this.newItem.setPosition(this.originalItem.position.x, this.originalItem.position.y);
            this.transferProperties();
            if (!MapScreen.canPlace(this.newItem, this.newItem.position, this.mapData.getGrid())) {
                Notifier.error("Modified item no longer has a valid placement on the grid.");
                this.updateItemPosition();
                return;
            }
            this.mapData.getGrid().placeItem(this.newItem);
            MapSaver.saveMap(this.mapData.getGrid(), this.mapData.getMetadata());
        }
        MapLoader.tryLoadMap(this.mapData.getMetadata()).ifPresent(md -> ScreenManager.instance().showScreen(new LevelEditorScreen((MapData)md)));
    }

    private void updateRoom() {
        float SCREEN_W = Gdx.graphics.getWidth();
        float SCREEN_H = Gdx.graphics.getHeight();
        Vector2 viewOrigin = this.getUIStage().stageToScreenCoordinates(new Vector2(250.0f, 300.0f));
        Vector2 viewSize = new Vector2(SCREEN_W, SCREEN_H).sub(viewOrigin);
        Vector2 roomSize = this.stageToScreenCoordinates(new Vector2(this.ROOM_W, this.ROOM_H));
        Vector2 roomOrigin = viewOrigin.add(viewSize.x / 2.0f, viewSize.y / 2.0f).sub(roomSize.x / 2.0f, roomSize.y / 2.0f);
        Vector2 gameCoordRoomOrigin = this.screenToStageCoordinates(roomOrigin);
        this.room.setPosition((int)gameCoordRoomOrigin.x, (int)gameCoordRoomOrigin.y);
        this.cameraManager.setPosition(gameCoordRoomOrigin.x, gameCoordRoomOrigin.y);
        this.updateItemPosition();
    }

    public void updateItemPosition() {
        this.newItem.setPosition((int)this.room.getX() + this.ROOM_W / 2 - this.newItem.getWidth() / 2, (int)this.room.getY() + this.ROOM_H / 2 - this.newItem.getHeight() / 2);
    }

    public void fillPropertyParams() {
        HashMap propertyParams = new HashMap();
        this.newItem.getProperties().forEach(prop -> {
            JsonValue val = new JsonReader().parse(new Json().toJson(prop));
            propertyParams.put(prop.getType(), val);
        });
        this.newItem.getType().propertyParameters = propertyParams;
    }

    public boolean modifyingItem() {
        return this.modifyingItem;
    }

    public void saveItem() {
        this.fillPropertyParams();
        if (!ItemSaver.saveCustomItem(this.newItem, this.mapData.getMetadata())) {
            Notifier.error("Failed to save " + this.newItem.getItemName());
        } else {
            Notifier.info("Saved item " + this.newItem.getItemName());
            this.dirty = false;
        }
    }

    @Override
    public void draw() {
        super.draw();
        Camera camera = this.getViewport().getCamera();
        camera.update();
        Batch batch = this.batch;
        batch.setProjectionMatrix(camera.combined);
        batch.begin();
        this.newItem.draw(batch);
        batch.end();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.newItem.update(delta);
    }

    @Override
    public void dispose() {
        screen = null;
        super.dispose();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        this.repack();
        this.updateRoom();
    }
}

