/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.Scaling;
import group24.escaperoom.AssetManager;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.data.Networking;
import group24.escaperoom.data.PlayerRecord;
import group24.escaperoom.data.Types;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.MenuScreen;
import group24.escaperoom.screens.OnlineMainMenu;
import group24.escaperoom.ui.FilterUI;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.widgets.G24TextButton;
import group24.escaperoom.utils.Notifier;
import java.util.function.BiFunction;

public class LeaderboardScreen
extends MenuScreen {
    G24TextButton backButton;
    private FilterUI filterUI;
    private G24TextButton filterButton = new G24TextButton("Filter Results");
    private Table entries = new Table();
    BiFunction<Types.Filters, Types.Sort, Void> onSearch = (arr, sort) -> {
        this.waitFor(Networking.listPlayerRecords((Types.ListPlayerRecordRequest)new Types.ListPlayerRecordRequest().withLimit(10).withSort((Types.Sort)sort).withFilters((Types.Filters)arr)), (T rsp) -> {
            this.entries.clear();
            this.addHeader();
            for (PlayerRecord data : rsp.records) {
                this.addEntry(data);
            }
            return null;
        }, "Applying filters...");
        return null;
    };
    ChangeListener onBackButton = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            ScreenManager.instance().showScreen(new OnlineMainMenu());
        }
    };
    private ChangeListener onFilter = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            LeaderboardScreen.this.filterButton.setChecked(false);
            LeaderboardScreen.this.filterUI.pack();
            LeaderboardScreen.this.filterUI.toFront();
            LeaderboardScreen.this.filterUI.setPosition(LeaderboardScreen.this.getUIStage().getWidth() / 2.0f - LeaderboardScreen.this.filterUI.getWidth() / 2.0f, LeaderboardScreen.this.getUIStage().getHeight() / 2.0f - LeaderboardScreen.this.filterUI.getHeight() / 2.0f);
            LeaderboardScreen.this.filterUI.setVisible(true);
        }
    };

    private void addEntry(PlayerRecord record) {
        this.entries.add(new SmallLabel(record.username, "white"));
        this.entries.add(new SmallLabel(Integer.toString(record.attempts), "white"));
        this.entries.add(new SmallLabel(Integer.toString(record.clears), "white"));
        this.entries.add(new SmallLabel(Integer.toString(record.clearList.size), "white"));
        this.entries.row();
    }

    private void addHeader() {
        this.entries.add(new SmallLabel("Username", "title"));
        this.entries.add(new SmallLabel("Attempts", "title"));
        this.entries.add(new SmallLabel("Map Clears", "title"));
        this.entries.add(new SmallLabel("Unique Clears", "title"));
        this.entries.row();
    }

    public LeaderboardScreen() {
        this.backButton = new G24TextButton("Back");
        this.backButton.addListener(this.onBackButton);
        this.entries.defaults().center().pad(10.0f);
        AssetManager.instance().load("textures/bkg.9.png", Texture.class);
        AssetManager.instance().finishLoadingAsset("textures/bkg.9.png");
        Texture bkg = AssetManager.instance().get("textures/bkg.9.png", Texture.class);
        NinePatch ninePatch = new NinePatch(bkg, 10, 10, 10, 10);
        NinePatchDrawable drawable = new NinePatchDrawable(ninePatch);
        drawable.tint(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        this.entries.setBackground(drawable);
        this.addHeader();
        this.filterUI = new FilterUI(this.onSearch, Types.ListPlayerRecordRequest.Field.class);
        this.filterButton.addListener(this.onFilter);
        this.filterButton.setProgrammaticChangeEvents(false);
        this.waitFor(Networking.listPlayerRecords((Types.ListPlayerRecordRequest)new Types.ListPlayerRecordRequest().withLimit(10).withSort(new Types.Sort("name"))), (T rsp) -> {
            Image title = new Image(AssetManager.instance().loadTextureBlocking("textures/leaderboard.png"));
            title.setScaling(Scaling.contain);
            this.rootTable.add(title).padTop(200.0f).maxWidth(800.0f).colspan(2).center().row();
            if (rsp.code == Networking.StatusCode.OK) {
                rsp.records.forEach(r -> this.addEntry((PlayerRecord)r));
            } else {
                Notifier.warn("Error fetching leaderboard...");
            }
            ScrollPane p = new ScrollPane((Actor)this.entries, AbstractScreen.skin, "nobkg");
            p.setFadeScrollBars(false);
            p.setScrollBarPositions(false, true);
            p.setForceScroll(false, true);
            this.rootTable.add(p).top().colspan(2).maxHeight(0.75f * this.getUIStage().getHeight()).expandX().row();
            p.pack();
            this.rootTable.add(this.backButton).bottom().left().expand();
            this.rootTable.add(this.filterButton).bottom().right().expand();
            this.filterUI.setVisible(false);
            this.addUI(this.filterUI);
            return null;
        }, "Fetching maps...");
    }
}

