/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.Input;
import group24.escaperoom.data.Drawable;
import group24.escaperoom.data.Grid;
import group24.escaperoom.data.MapData;
import group24.escaperoom.data.MapLoader;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.objects.ObjectLoader;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.screens.SinglePlayerGameScreen;
import group24.escaperoom.screens.editor.ActionHistory;
import group24.escaperoom.screens.editor.CamMan;
import group24.escaperoom.screens.editor.DragManager;
import group24.escaperoom.screens.editor.GridView;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.EditorSettingsDialog;
import group24.escaperoom.ui.EditorUI;
import group24.escaperoom.ui.KeyMapDialog;
import group24.escaperoom.ui.editor.ItemMenu;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.editorTools.Brush;
import group24.escaperoom.ui.editorTools.DeletionTool;
import group24.escaperoom.ui.editorTools.EditorTool;
import group24.escaperoom.ui.editorTools.EyeDropTool;
import group24.escaperoom.ui.editorTools.ItemDrawer;
import group24.escaperoom.ui.editorTools.ItemSelectionTool;
import group24.escaperoom.ui.editorTools.MoveTool;
import group24.escaperoom.ui.editorTools.PanTool;
import group24.escaperoom.ui.editorTools.RotationTool;
import group24.escaperoom.ui.widgets.G24Dialog;
import group24.escaperoom.utils.Notifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;

public class LevelEditorScreen
extends MapScreen {
    private Logger log = Logger.getLogger(LevelEditorScreen.class.getName());
    private ItemDrawer itemDrawer;
    private ToolManager toolManager;
    private ActionHistory history;
    private DragManager dragManager;
    private EditorUI ui;
    private GridView gridView;
    private Optional<Item> selectedItem = Optional.empty();
    private Optional<MoveTool.SoloMoveTool> movingItem = Optional.empty();
    private final HashSet<Drawable> overlayDrawables = new HashSet();
    private boolean dragging = false;
    private boolean panEnabled = true;
    ItemMenu itemMenu = null;

    public LevelEditorScreen(MapData data) {
        super(data);
        this.itemDrawer = new ItemDrawer(this);
        this.toolManager = new ToolManager(this, this.itemDrawer);
        this.history = new ActionHistory();
        this.dragManager = new DragManager(this, this.roomProxy);
        this.ui = new EditorUI(this, this.toolManager, this.dragManager, this.history, this.itemDrawer);
        this.setEditMode();
        this.loadGrid(data.getGrid());
        this.cameraManager.setPosition(this.gridSize.width / 2, this.gridSize.height / 2);
    }

    public Array<Item> getItemPrototypes() {
        return this.itemDrawer.getItemPrototypes();
    }

    private void setEditMode() {
        this.registerEditBinds();
        this.addUI(this.ui.getRoot());
        this.followActor = Optional.empty();
    }

    public void setPlayMode() {
        Optional<Item> playerStart = this.grid.findItemWhere(new Predicate<Item>(){

            @Override
            public boolean test(Item arg0) {
                return arg0.hasProperty(PropertyType.Player);
            }
        });
        if (playerStart.isEmpty()) {
            Notifier.warn("Cannot play without player start\nSee GameControl -> Mr. E");
            return;
        }
        this.grid.placedItems.values().forEach(i -> i.setSelected(false));
        this.clearGridView();
        CursorManager.restoreDefault();
        ScreenManager.instance().showScreen(new SinglePlayerGameScreen(new MapData(this.grid, this.metadata)));
    }

    @Override
    public MapMetadata getMetadata() {
        return this.metadata;
    }

    public ItemSelectionTool getSelectionTool() {
        return this.toolManager.getSelectTool();
    }

    public EditorUI getUI() {
        return this.ui;
    }

    public DragAndDrop getDragAndDrop() {
        return this.dragManager.getDragAndDrop();
    }

    public void deselectTools() {
        this.toolManager.deselectAll();
    }

    public void setActiveTool(EditorTool tool) {
        this.toolManager.setTool(tool);
    }

    public EditorTool getActiveTool() {
        if (this.toolManager.getActiveTool().isEmpty()) {
            return null;
        }
        return this.toolManager.getActiveTool().get();
    }

    public EditorTool getTool(ToolManager.ToolType type) {
        return this.toolManager.getTool(type);
    }

    public void recordEditorAction(ActionHistory.EditorAction action) {
        this.history.record(action);
    }

    public Optional<Item> getSelectedItem() {
        return this.selectedItem;
    }

    public Optional<Item> priorityItemAt(int x, int y) {
        Item item;
        Item inFlight = this.dragManager.getInFlightItem();
        if (inFlight != null) {
            return Optional.of(inFlight);
        }
        Optional<Item[]> maybeItems = this.getItemsAt(x, y);
        if (maybeItems.isEmpty()) {
            return Optional.empty();
        }
        Item[] items = maybeItems.get();
        if (items.length == 0) {
            return Optional.empty();
        }
        if (this.selectedItem.isPresent()) {
            item = this.selectedItem.get();
            for (int i = 0; i < items.length; ++i) {
                if (items[i].getID() != item.getID()) continue;
                return Optional.of(items[i]);
            }
        }
        item = null;
        int maxRender = Integer.MIN_VALUE;
        for (int i = items.length - 1; i >= 0; --i) {
            if (items[i].renderPriority() <= maxRender || items[i].getAlpha() != 1.0f) continue;
            item = items[i];
            maxRender = item.renderPriority();
        }
        if (item == null) {
            return Optional.empty();
        }
        return Optional.of(item);
    }

    private Optional<Array<Item>> selectedItemsAt(int x, int y) {
        return this.getItemsAt(x, y).flatMap(items -> {
            if (((Item[])items).length == 0) {
                return Optional.empty();
            }
            Array<Item> ret = new Array<Item>();
            for (Item i : items) {
                if (!i.selected) continue;
                ret.add(i);
            }
            return ret.isEmpty() ? Optional.empty() : Optional.of(ret);
        });
    }

    private Optional<Item> nextItemAt(int x, int y) {
        return this.getItemsAt(x, y).flatMap(items -> {
            if (((Item[])items).length == 0) {
                return Optional.empty();
            }
            Item[] sortedItems = Arrays.copyOf(items, ((Item[])items).length);
            Arrays.sort(sortedItems, (a, b) -> new Grid.DrawableComparator().compare((Drawable)a, (Drawable)b));
            int index = sortedItems.length - 1;
            if (this.selectedItem.isPresent()) {
                Item selection = this.selectedItem.get();
                for (int i = sortedItems.length - 1; i >= 0; --i) {
                    if (sortedItems[i].getID() != selection.getID()) continue;
                    if (i == 0) {
                        index = sortedItems.length - 1;
                        break;
                    }
                    index = i - 1;
                    break;
                }
            }
            return Optional.of(sortedItems[index]);
        });
    }

    private void openItemMenu(Item i) {
        this.itemMenu = new ItemMenu(i, this);
        this.addUI(this.itemMenu);
        BackManager.addBack(() -> {
            if (this.itemMenu == null || this.itemMenu.getStage() == null) {
                return false;
            }
            this.itemMenu.close();
            this.itemMenu = null;
            return true;
        });
    }

    @Override
    public boolean itemIsPlaced(Item i) {
        return this.grid.placedItems.containsKey(i.getID());
    }

    public boolean collidesMenu(float x, float y) {
        for (Actor a : this.getUIStage().getRoot().getChildren()) {
            Window m;
            Rectangle bounds;
            if (!(a instanceof Menu ? (bounds = new Rectangle((m = (Menu)a).getX(), m.getY(), m.getWidth(), m.getHeight())).contains(new Vector2(x, y)) : a instanceof G24Dialog && (bounds = new Rectangle((m = (G24Dialog)a).getX(), m.getY(), m.getWidth(), m.getHeight())).contains(new Vector2(x, y)))) continue;
            return true;
        }
        return false;
    }

    public <T extends Menu> Menu.MenuEntry collidedMenuEntry(float x, float y, Class<T> type) {
        for (Actor a : this.getUIStage().getRoot().getChildren()) {
            if (!type.isAssignableFrom(a.getClass())) continue;
            Menu m = (Menu)a;
            for (Actor e : m.getChildren()) {
                if (!(e instanceof Menu.MenuEntry)) continue;
                Menu.MenuEntry me = (Menu.MenuEntry)e;
                Vector2 pos = me.localToStageCoordinates(new Vector2(0.0f, 0.0f));
                Rectangle bounds = new Rectangle(pos.x, pos.y, me.getWidth(), me.getHeight());
                if (!bounds.contains(new Vector2(x, y))) continue;
                return me;
            }
        }
        return null;
    }

    private void zoomIn() {
        this.cameraManager.zoomIn();
        this.updateProxy();
    }

    private void zoomOut() {
        this.cameraManager.zoomOut();
        this.updateProxy();
    }

    public void setPanEnabled(boolean panEnabled) {
        this.panEnabled = panEnabled;
    }

    public void panCamera(float x, float y) {
        this.cameraManager.translate(x, y);
    }

    private void closeItemMenu() {
        if (this.itemMenu != null) {
            this.itemMenu.close();
            this.itemMenu = null;
        }
    }

    public void panCamera(CamMan.Translation translation) {
        this.cameraManager.translate(translation);
        this.toolManager.getActiveTool().ifPresent(t -> {
            DeletionTool dt;
            if (t.getType() == ToolManager.ToolType.Brush) {
                Vector2 gameCoord = this.screenToStageCoordinates(new Vector2(Gdx.input.getX(), Gdx.input.getY()));
                Brush b = (Brush)t;
                if (b.isDrawing()) {
                    b.handleDrag(gameCoord.x, gameCoord.y);
                }
            } else if (t.getType() == ToolManager.ToolType.Deletion && (dt = (DeletionTool)t).isDeleting()) {
                Vector2 gameCoord = this.screenToStageCoordinates(new Vector2(Gdx.input.getX(), Gdx.input.getY()));
                dt.handleDrag(gameCoord.x, gameCoord.y);
            }
        });
    }

    public void reloadItems() {
        MapLoader.reloadTextures(this.metadata);
        this.metadata.objectDirectory.ifPresent(uo -> ObjectLoader.LoadUserObjects(uo));
        this.grid.items.values().forEach(i -> i.reloadTexture());
        this.ui.getRoot().remove();
        this.itemDrawer = new ItemDrawer(this);
        this.toolManager = new ToolManager(this, this.itemDrawer);
        this.ui = new EditorUI(this, this.toolManager, this.dragManager, this.history, this.itemDrawer);
        this.addUI(this.ui.getRoot());
    }

    public void setGridView(GridView view) {
        this.gridView = view;
    }

    public void clearGridView() {
        if (this.gridView != null) {
            this.gridView.reset(this.grid.placedItems.values());
        }
        this.gridView = null;
    }

    public void applyGridView() {
        if (this.gridView != null) {
            Collection<Item> placedItems = this.grid.placedItems.values();
            this.gridView.apply(placedItems);
        }
    }

    public void addOverlayDrawable(Drawable drawable) {
        this.overlayDrawables.add(drawable);
    }

    public void removeOverlayDrawable(Drawable drawable) {
        this.overlayDrawables.remove(drawable);
    }

    private void selectItem(Item item) {
        this.selectedItem.ifPresent(i -> i.setSelected(false));
        this.selectedItem = Optional.of(item);
        this.getSelectionTool().getSelection().ifPresent(s -> s.clearSelectedItems());
        this.ui.getHints().itemHint.setMode(EditorUI.ItemHintMode.Selected);
        item.setSelected(true);
        BackManager.addBack(() -> {
            if (this.selectedItem.isEmpty() || this.selectedItem.get().getID() != item.getID()) {
                return false;
            }
            item.setSelected(false);
            this.selectedItem = Optional.empty();
            this.ui.getHints().itemHint.setMode(EditorUI.ItemHintMode.Hover);
            return true;
        });
    }

    @Override
    public void draw() {
        this.applyGridView();
        this.draw(false);
        this.overlayDrawables.forEach(d -> d.draw(this.batch));
        this.batch.end();
    }

    public boolean shouldHandleTouchDown() {
        int x = Gdx.input.getX();
        int y = Gdx.input.getY();
        Vector2 uiPos = this.getUIStage().screenToStageCoordinates(new Vector2(x, y));
        if (this.collidesMenu(uiPos.x, uiPos.y)) {
            return false;
        }
        return this.panEnabled && this.toolManager.getActiveTool().isEmpty() && this.itemDrawer.getSelection().isEmpty();
    }

    private void registerEditBinds() {
        this.addListener(new InputListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                if (amountY < 0.0f) {
                    LevelEditorScreen.this.cameraManager.zoomOut();
                } else if (amountY > 0.0f) {
                    LevelEditorScreen.this.cameraManager.zoomIn();
                }
                return true;
            }

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!LevelEditorScreen.this.shouldHandleTouchDown() || button != 0) {
                    return false;
                }
                LevelEditorScreen.this.getUIStage().setScrollFocus(null);
                LevelEditorScreen.this.movingItem = LevelEditorScreen.this.priorityItemAt((int)x, (int)y).map(i -> new MoveTool.SoloMoveTool((Item)i, LevelEditorScreen.this));
                if (LevelEditorScreen.this.movingItem.isEmpty() && LevelEditorScreen.this.panEnabled) {
                    ((PanTool)LevelEditorScreen.this.toolManager.getTool(ToolManager.ToolType.Pan)).handleTouchDown();
                }
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (LevelEditorScreen.this.dragging) {
                    LevelEditorScreen.this.movingItem.ifPresent(mt -> mt.handleUp(x, y));
                }
                LevelEditorScreen.this.movingItem = Optional.empty();
                LevelEditorScreen.this.dragging = false;
                CursorManager.restoreDefault();
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                LevelEditorScreen.this.movingItem.ifPresentOrElse(mt -> {
                    LevelEditorScreen.this.selectedItem.ifPresent(si -> {
                        if (si.getID() != mt.getItem().getID()) {
                            LevelEditorScreen.this.selectItem(mt.getItem());
                        }
                    });
                    mt.handleDrag(x, y);
                    LevelEditorScreen.this.dragging = true;
                }, () -> {
                    if (LevelEditorScreen.this.panEnabled) {
                        ((PanTool)LevelEditorScreen.this.toolManager.getTool(ToolManager.ToolType.Pan)).handleDrag();
                        CursorManager.setCursor(CursorManager.CursorType.Hand);
                    }
                });
            }
        });
        BackManager.setOnEmpty(() -> new EditorSettingsDialog().show(this.getUIStage()));
        ControlsManager.registerInput(Input.ZOOM_OUT, ControlsManager.InputType.HELD, () -> this.zoomOut());
        ControlsManager.registerInput(Input.ZOOM_IN, ControlsManager.InputType.HELD, () -> this.zoomIn());
        ControlsManager.registerInput(Input.MOVE_UP, ControlsManager.InputType.HELD, () -> this.panCamera(CamMan.Translation.Up));
        ControlsManager.registerInput(Input.MOVE_LEFT, ControlsManager.InputType.HELD, () -> this.panCamera(CamMan.Translation.Left));
        ControlsManager.registerInput(Input.MOVE_DOWN, ControlsManager.InputType.HELD, () -> this.panCamera(CamMan.Translation.Down));
        ControlsManager.registerInput(Input.MOVE_RIGHT, ControlsManager.InputType.HELD, () -> this.panCamera(CamMan.Translation.Right));
        ControlsManager.registerInput(Input.KEYBIND_HELP, ControlsManager.InputType.PRESSED, () -> new KeyMapDialog().show(this.getUIStage()));
        ControlsManager.registerInput(Input.ROTCW, ControlsManager.InputType.PRESSED, () -> {
            if (this.movingItem.isPresent()) {
                Item i2 = this.movingItem.get().getItem();
                i2.rotateBy(90);
                this.recordEditorAction(new RotationTool.RotationAction(i2));
                return;
            }
            int x = Gdx.input.getX();
            int y = Gdx.input.getY();
            Types.IntVector2 pos = Types.IntVector2.fromVector2(this.screenToStageCoordinates(new Vector2(x, y)));
            this.priorityItemAt(pos.x, pos.y).ifPresent(i -> {
                i.rotateBy(90);
                this.recordEditorAction(new RotationTool.RotationAction((Item)i));
            });
        });
        ControlsManager.registerInput(Input.ROTCCW, ControlsManager.InputType.PRESSED, () -> {
            if (this.movingItem.isPresent()) {
                Item i2 = this.movingItem.get().getItem();
                i2.rotateBy(-90);
                this.recordEditorAction(new RotationTool.RotationAction(i2));
                return;
            }
            int x = Gdx.input.getX();
            int y = Gdx.input.getY();
            Types.IntVector2 pos = Types.IntVector2.fromVector2(this.screenToStageCoordinates(new Vector2(x, y)));
            this.priorityItemAt(pos.x, pos.y).ifPresent(i -> {
                i.rotateBy(-90);
                this.recordEditorAction(new RotationTool.RotationAction((Item)i));
            });
        });
        ControlsManager.registerInput(Input.MIRROR_H, ControlsManager.InputType.PRESSED, () -> {
            if (this.movingItem.isPresent()) {
                this.movingItem.get().getItem().mirrorHorizontal();
                return;
            }
            int x = Gdx.input.getX();
            int y = Gdx.input.getY();
            Types.IntVector2 pos = Types.IntVector2.fromVector2(this.screenToStageCoordinates(new Vector2(x, y)));
            this.priorityItemAt(pos.x, pos.y).ifPresent(i -> i.mirrorHorizontal());
        });
        ControlsManager.registerInput(Input.MIRROR_V, ControlsManager.InputType.PRESSED, () -> {
            if (this.movingItem.isPresent()) {
                this.movingItem.get().getItem().mirrorVertical();
                return;
            }
            int x = Gdx.input.getX();
            int y = Gdx.input.getY();
            Types.IntVector2 pos = Types.IntVector2.fromVector2(this.screenToStageCoordinates(new Vector2(x, y)));
            this.priorityItemAt(pos.x, pos.y).ifPresent(i -> i.mirrorVertical());
        });
        ControlsManager.registerInput(Input.TOOL_PAN, ControlsManager.InputType.PRESSED, () -> this.toolManager.setTool(ToolManager.ToolType.Pan));
        ControlsManager.registerInput(Input.TOOL_FILL, ControlsManager.InputType.PRESSED, () -> {
            if (this.toolManager.canFill()) {
                this.toolManager.setTool(ToolManager.ToolType.Fill);
            }
        });
        ControlsManager.registerInput(Input.COPY, ControlsManager.InputType.PRESSED, () -> {
            if (this.selectedItem.isEmpty()) {
                return;
            }
            EyeDropTool itmCpy = (EyeDropTool)this.toolManager.getTool(ToolManager.ToolType.EyeDrop);
            this.setActiveTool(itmCpy);
            itmCpy.copyItem(this.selectedItem.get());
        });
        ControlsManager.registerInput(Input.PASTE, ControlsManager.InputType.PRESSED, () -> {
            Vector2 screenPos = new Vector2(Gdx.input.getX(), Gdx.input.getY());
            Vector2 position = this.screenToStageCoordinates(screenPos);
            EyeDropTool itmCpy = (EyeDropTool)this.toolManager.getTool(ToolManager.ToolType.EyeDrop);
            itmCpy.pasteAt(position);
        });
        ControlsManager.registerInput(Input.TOOL_ROT, ControlsManager.InputType.PRESSED, () -> this.toolManager.setTool(ToolManager.ToolType.Rotation));
        ControlsManager.registerInput(Input.TOOL_MOV, ControlsManager.InputType.PRESSED, () -> this.toolManager.setTool(ToolManager.ToolType.Move));
        ControlsManager.registerInput(Input.TOOL_PPT, ControlsManager.InputType.PRESSED, () -> this.toolManager.setTool(ToolManager.ToolType.Properties));
        ControlsManager.registerInput(Input.TOOL_SEL, ControlsManager.InputType.PRESSED, () -> this.toolManager.setTool(ToolManager.ToolType.ItemSelect));
        ControlsManager.registerInput(Input.TOOL_DEL, ControlsManager.InputType.PRESSED, () -> this.toolManager.setTool(ToolManager.ToolType.Deletion));
        ControlsManager.registerInput(Input.TOOL_EYEDROP, ControlsManager.InputType.PRESSED, () -> this.toolManager.setTool(ToolManager.ToolType.EyeDrop));
        ControlsManager.registerInput(Input.UNDO, ControlsManager.InputType.PRESSED, () -> this.history.undo());
        ControlsManager.registerInput(Input.REDO, ControlsManager.InputType.PRESSED, () -> this.history.redo());
        ControlsManager.registerInput(Input.DELETE_SELECTION, ControlsManager.InputType.PRESSED, () -> {
            this.toolManager.getSelectTool().deleteSelected();
            if (this.selectedItem.isPresent()) {
                this.selectedItem.get().remove();
                this.recordEditorAction(new DeletionTool.Deletion(this, this.selectedItem.get()));
                this.selectedItem = Optional.empty();
            }
        });
        ControlsManager.registerInput(Input.SELECT_MULTI, ControlsManager.InputType.PRESSED, () -> {
            if (!this.shouldHandleTouchDown()) {
                return;
            }
            this.closeItemMenu();
            Vector2 screenTouchDown = new Vector2(Gdx.input.getX(), Gdx.input.getY());
            Vector2 position = this.screenToStageCoordinates(screenTouchDown);
            this.nextItemAt((int)position.x, (int)position.y).ifPresent(item -> {
                Array multiSelect = this.getSelectionTool().getSelection().map(s -> s.getItems()).orElseGet(() -> new Array());
                this.selectedItem.ifPresent(i -> multiSelect.add(i));
                this.selectedItem = Optional.empty();
                if (item.selected) {
                    multiSelect.removeValue(item, false);
                    return;
                }
                item.setSelected(true);
                multiSelect.add(item);
                this.getSelectionTool().setItems(multiSelect);
                BackManager.addBack(() -> {
                    if (this.getSelectionTool().getSelection().isEmpty()) {
                        return false;
                    }
                    this.getSelectionTool().getSelection().get().clearSelectedItems();
                    this.ui.getHints().itemHint.setMode(EditorUI.ItemHintMode.Hover);
                    return true;
                });
            });
        });
        ControlsManager.registerInput(Input.SELECT, ControlsManager.InputType.PRESSED, () -> {
            if (!this.shouldHandleTouchDown()) {
                return;
            }
            this.closeItemMenu();
            Vector2 screenTouchDown = new Vector2(Gdx.input.getX(), Gdx.input.getY());
            Vector2 position = this.screenToStageCoordinates(screenTouchDown);
            this.nextItemAt((int)position.x, (int)position.y).ifPresent(item -> this.selectItem((Item)item));
        });
        ControlsManager.registerInput(Input.CONTEXT, ControlsManager.InputType.PRESSED, () -> {
            if (!this.shouldHandleTouchDown()) {
                return;
            }
            this.closeItemMenu();
            Vector2 screenTouchDown = new Vector2(Gdx.input.getX(), Gdx.input.getY());
            Vector2 position = this.screenToStageCoordinates(screenTouchDown);
            if (this.selectedItem.isPresent() && this.selectedItem.get().getOccupiedRegion().contains(position)) {
                this.openItemMenu(this.selectedItem.get());
                return;
            }
            this.nextItemAt((int)position.x, (int)position.y).ifPresent(item -> this.openItemMenu((Item)item));
        });
    }
}

