/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.data.Networking;
import group24.escaperoom.data.User;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.MainMenuScreen;
import group24.escaperoom.screens.MenuScreen;
import group24.escaperoom.screens.OnlineMainMenu;
import group24.escaperoom.ui.widgets.G24TextButton;
import group24.escaperoom.ui.widgets.G24TextInput;
import group24.escaperoom.utils.Notifier;

public class LoginScreen
extends MenuScreen {
    G24TextInput userNameField;
    G24TextInput passwordField;
    G24TextInput confirmPasswordField;
    int FIELD_WIDTH = 300;
    String username;
    String password;
    LoginButton loginButton;
    CreateAccountButton createAccountButton;
    TextButton backButton;
    ChangeListener onBackButton = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            ScreenManager.instance().showScreen(new MainMenuScreen());
        }
    };

    @Override
    public void init() {
        this.userNameField = new G24TextInput("", skin);
        this.userNameField.setAlphanumeric();
        this.userNameField.setOnEnter(() -> {
            if (this.loginButton.getStage() != null) {
                this.loginButton.tryLogin();
            } else {
                this.createAccountButton.tryCreateAccount();
            }
        });
        this.passwordField = new G24TextInput("", skin);
        this.passwordField.setPasswordMode(true);
        this.passwordField.setOnEnter(() -> {
            if (this.loginButton.getStage() != null) {
                this.loginButton.tryLogin();
            } else {
                this.createAccountButton.tryCreateAccount();
            }
        });
        this.confirmPasswordField = new G24TextInput("", skin);
        this.confirmPasswordField.setPasswordMode(true);
        this.confirmPasswordField.setOnEnter(() -> {
            if (this.loginButton.getStage() != null) {
                this.loginButton.tryLogin();
            } else {
                this.createAccountButton.tryCreateAccount();
            }
        });
        this.backButton = new G24TextButton("<-");
        this.backButton.addListener(this.onBackButton);
        this.loginButton = new LoginButton();
        this.createAccountButton = new CreateAccountButton();
        this.buildUI();
        BackManager.addBack(() -> ScreenManager.instance().showScreen(new MainMenuScreen()));
    }

    private void buildUI() {
        this.addUI(this.backButton);
        this.backButton.setPosition(0.0f + this.backButton.getWidth() + 5.0f, this.getUIStage().getHeight() - this.backButton.getHeight() - 30.0f);
        this.rootTable.defaults().pad(10.0f);
        this.rootTable.setFillParent(true);
        this.passwordField.setMaxLength(this.FIELD_WIDTH);
        this.userNameField.setMaxLength(this.FIELD_WIDTH);
        this.rootTable.add(new Label("USERNAME:", skin, "bubble"));
        this.rootTable.add(this.userNameField).width(this.FIELD_WIDTH);
        this.rootTable.row();
        this.rootTable.add(new Label("PASSWORD:", skin, "bubble"));
        this.rootTable.add(this.passwordField).width(this.FIELD_WIDTH);
        this.rootTable.row();
        this.rootTable.add(this.loginButton).colspan(2);
        this.rootTable.row();
        this.rootTable.add(this.createAccountButton).colspan(2);
    }

    private class LoginButton
    extends G24TextButton {
        ChangeListener tryLoginListener;

        public LoginButton() {
            super("Login");
            this.tryLoginListener = new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (!LoginButton.this.isChecked()) {
                        return;
                    }
                    LoginButton.this.tryLogin();
                }
            };
            this.setProgrammaticChangeEvents(false);
            this.addListener(this.tryLoginListener);
        }

        void tryLogin() {
            this.setChecked(false);
            LoginScreen.this.waitFor(User.AttemptLogin(LoginScreen.this.userNameField.getText(), LoginScreen.this.passwordField.getText()), code -> {
                if (User.isLoggedIn() && code == Networking.StatusCode.OK) {
                    ScreenManager.instance().showScreen(new OnlineMainMenu());
                } else {
                    Notifier.warn("Error logging in: " + code.toString());
                }
                return null;
            });
        }
    }

    private class CreateAccountButton
    extends G24TextButton {
        ChangeListener switchToCreateAccount;
        ChangeListener tryAccountCreation;

        public CreateAccountButton() {
            super("Create Account");
            this.switchToCreateAccount = new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    CreateAccountButton.this.setChecked(false);
                    LoginScreen.this.rootTable.clear();
                    LoginScreen.this.rootTable.add(new Label("USERNAME", AbstractScreen.skin, "bubble"));
                    LoginScreen.this.rootTable.add(LoginScreen.this.userNameField).width(300.0f);
                    LoginScreen.this.rootTable.row();
                    LoginScreen.this.rootTable.add(new Label("PASSWORD", AbstractScreen.skin, "bubble"));
                    LoginScreen.this.rootTable.add(LoginScreen.this.passwordField).width(300.0f);
                    LoginScreen.this.rootTable.row();
                    LoginScreen.this.rootTable.add(new Label("CONFIRM PASSWORD", AbstractScreen.skin, "bubble"));
                    LoginScreen.this.rootTable.add(LoginScreen.this.confirmPasswordField).width(300.0f);
                    LoginScreen.this.rootTable.row();
                    LoginScreen.this.rootTable.add(CreateAccountButton.this).colspan(2);
                    CreateAccountButton.this.removeListener(CreateAccountButton.this.switchToCreateAccount);
                    CreateAccountButton.this.addListener(CreateAccountButton.this.tryAccountCreation);
                }
            };
            this.tryAccountCreation = new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (!CreateAccountButton.this.isChecked()) {
                        return;
                    }
                    CreateAccountButton.this.tryCreateAccount();
                }
            };
            this.setProgrammaticChangeEvents(false);
            this.addListener(this.switchToCreateAccount);
        }

        void tryCreateAccount() {
            this.setChecked(false);
            if (!LoginScreen.this.passwordField.getText().equals(LoginScreen.this.confirmPasswordField.getText())) {
                Notifier.error("Passwords do not match");
                return;
            }
            LoginScreen.this.waitFor(User.createAccount(LoginScreen.this.userNameField.getText(), LoginScreen.this.passwordField.getText()), code -> {
                if (User.isLoggedIn()) {
                    ScreenManager.instance().showScreen(new OnlineMainMenu());
                } else {
                    Notifier.error("Failed to create account: (code: " + code.name() + ")");
                }
                return null;
            }, "Creating account and logging in");
        }
    }
}

