/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Scaling;
import group24.escaperoom.AssetManager;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.data.MapLoader;
import group24.escaperoom.screens.LoginScreen;
import group24.escaperoom.screens.MapSelectScreen;
import group24.escaperoom.screens.MenuScreen;
import group24.escaperoom.ui.widgets.G24TextButton;

public class MainMenuScreen
extends MenuScreen {
    G24TextButton loginButton;
    private ChangeListener onLogin = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            ScreenManager.instance().showScreen(new LoginScreen());
        }
    };
    G24TextButton myMapsButton;
    private ChangeListener onMyMaps = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            ScreenManager.instance().showScreen(new MapSelectScreen.MapSelectScreenBuilder(new MainMenuScreen()).withMaps(MapLoader.discoverMaps()).edit().play().delete().creation().build());
        }
    };
    G24TextButton exitButton;
    private ChangeListener onExit = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            Gdx.app.exit();
        }
    };

    @Override
    public void init() {
        this.exitButton = new G24TextButton("Exit");
        this.exitButton.addListener(this.onExit);
        this.loginButton = new G24TextButton("Login");
        this.loginButton.addListener(this.onLogin);
        this.myMapsButton = new G24TextButton("My Maps");
        this.myMapsButton.addListener(this.onMyMaps);
        this.buildUI();
    }

    public void buildUI() {
        this.rootTable.defaults().pad(10.0f);
        Image title_img = new Image(AssetManager.instance().loadTextureBlocking("textures/title.png"));
        title_img.setScaling(Scaling.contain);
        this.rootTable.add(title_img).center().padLeft(20.0f).padRight(20.0f).padBottom(0.0f);
        this.rootTable.row();
        this.rootTable.add(this.loginButton).minWidth(300.0f);
        this.rootTable.row();
        this.rootTable.add(this.myMapsButton).minWidth(300.0f);
        this.rootTable.row();
        this.rootTable.add(this.exitButton).minWidth(300.0f);
        this.rootTable.setFillParent(true);
    }
}

