/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import group24.escaperoom.AssetManager;
import group24.escaperoom.data.Drawable;
import group24.escaperoom.data.EditorEvent;
import group24.escaperoom.data.EditorEventBus;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.data.Grid;
import group24.escaperoom.data.MapData;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.ConditionallyActive;
import group24.escaperoom.entities.properties.Connectable;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.GameScreen;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.CamMan;
import group24.escaperoom.utils.Types;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Logger;

public abstract class MapScreen
extends AbstractScreen {
    private Logger log = Logger.getLogger(MapScreen.class.getName());
    protected Actor roomProxy;
    protected Image room;
    public Grid grid;
    protected final Batch batch;
    protected MapMetadata metadata;
    protected Types.Size gridSize;
    protected Array<Item> pollItems = new Array();
    protected CamMan cameraManager;

    public MapMetadata getMetadata() {
        return this.metadata;
    }

    public void removeItemFromGrid(Item item, boolean temporary) {
        if (this instanceof GameScreen) {
            GameContext ctx = new GameContext((GameScreen)this);
            Connectable.Utils.isConnectable(item).ifPresent(ci -> ci.connectable.setActive(false, ctx));
        }
        if (!temporary && this instanceof LevelEditorScreen) {
            EditorEventBus.post(new EditorEvent(EditorEvent.EventType.ItemRemoved, item));
        }
        this.grid.removeItem(item);
        Connectable.Utils.maybeUpateSurroundingTileables(item, this);
    }

    protected void updateProxy() {
        Vector2 proxyOrigin = this.gameCoordToUI(new Vector2(0.0f, 0.0f));
        Vector2 proxyDiagonalPoint = this.gameCoordToUI(new Vector2(this.gridSize.width, this.gridSize.height));
        this.roomProxy.setBounds(proxyOrigin.x, proxyOrigin.y, proxyDiagonalPoint.x - proxyOrigin.x, proxyDiagonalPoint.y - proxyOrigin.y);
    }

    public boolean containsItemWhere(Predicate<Item> predicate) {
        return this.grid.containsItemWhere(predicate);
    }

    public Optional<Item> findItemWhere(Predicate<Item> predicate) {
        return this.grid.findItemWhere(predicate);
    }

    public Optional<Item[]> getItemsAt(Types.IntVector2 pos) {
        return this.grid.getAt(pos.x, pos.y).map(t -> t.getContainedItems());
    }

    public Optional<Item[]> getItemsAt(int x, int y) {
        return this.grid.getAt(x, y).map(t -> t.getContainedItems());
    }

    public Optional<Item[]> getItemsAt(float x, float y) {
        return this.getItemsAt((int)x, (int)y);
    }

    public HashSet<Item> getItemsIn(Rectangle region) {
        int minX = (int)region.getX();
        int minY = (int)region.getY();
        int maxX = (int)(region.getX() + region.getWidth());
        int maxY = (int)(region.getY() + region.getHeight());
        HashSet<Item> items = new HashSet<Item>();
        for (int y = minY; y < maxY; ++y) {
            for (int x = minX; x < maxX; ++x) {
                this.grid.getAt(x, y).map(t -> t.getContainedItems()).ifPresent(is -> {
                    for (Item i : is) {
                        items.add(i);
                    }
                });
            }
        }
        return items;
    }

    public static boolean canPlace(Item item, Types.IntVector2 newPos, Grid grid) {
        for (int dy = 0; dy < item.getHeight(); ++dy) {
            for (int dx = 0; dx < item.getWidth(); ++dx) {
                Optional<Grid.Tile> t = grid.getAt(newPos.x + dx, newPos.y + dy);
                if (t.isEmpty()) {
                    return false;
                }
                Grid.Tile tile = t.get();
                if (tile.canAdd(item)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canPlace(Item item, Types.IntVector2 newPos) {
        return MapScreen.canPlace(item, newPos, this.grid);
    }

    public MapScreen(MapData mapdata) {
        this.batch = new SpriteBatch();
        this.metadata = mapdata.getMetadata();
        this.gridSize = mapdata.getGrid().getSize();
        this.cameraManager = new CamMan((OrthographicCamera)this.getCamera());
        this.cameraManager.setZoom(this.metadata.gameSettings.defaultZoom);
        AssetManager.instance().load("textures/tile.png", Texture.class);
        AssetManager.instance().finishLoading();
        Texture tile = AssetManager.instance().get("textures/tile.png", Texture.class);
        tile.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        TextureRegion roomTexture = new TextureRegion(tile);
        roomTexture.setRegion(0, 0, tile.getWidth() * this.gridSize.width, tile.getHeight() * this.gridSize.height);
        this.room = new Image(roomTexture);
        this.room.setPosition(0.0f, 0.0f);
        this.room.setSize(this.gridSize.width, this.gridSize.height);
        this.room.setName("room");
        this.roomProxy = new Actor();
        this.updateProxy();
        this.addUI(this.roomProxy);
        this.addActor(this.room);
        this.addListener(new InputListener(){

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                if (character == 'j') {
                    Json j = new Json();
                    String json = j.prettyPrint(MapScreen.this.grid);
                    if (json.length() > 10000) {
                        File f = new File("/tmp/" + UUID.randomUUID().toString() + ".json");
                        try {
                            FileOutputStream fout = new FileOutputStream(f);
                            fout.write(json.getBytes());
                            fout.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        System.out.println("file length over 10,000 -> wrote to: " + f.getAbsolutePath());
                        return true;
                    }
                    System.out.println(json);
                }
                return false;
            }
        });
    }

    public void loadGrid(Grid grid) {
        if (grid == null) {
            return;
        }
        this.grid = grid;
        for (Item item : grid.items.values()) {
            item.map = this;
            this.maybeAddPolling(item);
        }
    }

    public void maybeAddPolling(Item item) {
        if (item.hasProperty(PropertyType.ConditionallyVisible)) {
            this.pollItems.add(item);
            return;
        }
        item.getProperty(PropertyType.ConditionallyActive, ConditionallyActive.class).ifPresent(ca -> {
            if (ca.requiresPoll()) {
                this.pollItems.add(item);
            }
        });
    }

    public Collection<Item> getItems() {
        return this.grid.items.values();
    }

    public boolean placeItem(Item item) {
        item.map = this;
        return this.grid.placeItem(item);
    }

    public Grid getGrid() {
        return this.grid;
    }

    public TreeSet<Drawable> getDrawables() {
        return this.grid.getDrawables();
    }

    public void draw(boolean endBatch) {
        Camera camera = this.getViewport().getCamera();
        camera.update();
        this.batch.setProjectionMatrix(this.getCamera().combined);
        this.batch.begin();
        this.getRoot().draw(this.batch, 1.0f);
        TreeSet<Drawable> drawables = this.getDrawables();
        for (Drawable i : drawables) {
            i.draw(this.batch);
        }
        if (endBatch) {
            this.batch.end();
        }
    }

    @Override
    public void draw() {
        this.draw(true);
    }

    public boolean itemIsPlaced(Item i) {
        return this.grid.placedItems.containsKey(i.getID());
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.updateProxy();
        for (Item i : this.grid.placedItems.values()) {
            i.update(delta);
        }
        this.room.setZIndex(0);
        this.roomProxy.setZIndex(0);
    }

    @Override
    public void resize(int w, int h) {
        super.resize(w, h);
        if (this.roomProxy != null) {
            this.updateProxy();
        }
    }

    public int getTileDepthOf(Item item) {
        return this.grid.getTileDepthOf(item);
    }
}

