/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Scaling;
import group24.escaperoom.AssetManager;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.data.MapData;
import group24.escaperoom.data.MapDownloader;
import group24.escaperoom.data.MapLoader;
import group24.escaperoom.data.MapManager;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.MapSaver;
import group24.escaperoom.data.MapUploader;
import group24.escaperoom.data.NotificationBus;
import group24.escaperoom.data.User;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.MainMenuScreen;
import group24.escaperoom.screens.MarketplaceScreen;
import group24.escaperoom.screens.MenuScreen;
import group24.escaperoom.screens.OnlineMainMenu;
import group24.escaperoom.screens.SinglePlayerGameScreen;
import group24.escaperoom.ui.CreateMapDialog;
import group24.escaperoom.ui.MapStatDialog;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.widgets.G24Dialog;
import group24.escaperoom.ui.widgets.G24TextButton;
import group24.escaperoom.utils.Notifier;
import java.io.File;

public class MapSelectScreen
extends MenuScreen {
    private MapSelectScreenSettings settings;
    protected Array<MapEntry> entries = new Array();
    protected VerticalGroup entriesUI = new VerticalGroup();
    private AbstractScreen returnTo;
    G24TextButton backButton;
    ChangeListener onBackButton = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            if (MapSelectScreen.this.returnTo == null) {
                ScreenManager.instance().showScreen(new MainMenuScreen());
            } else {
                NotificationBus.get().removeListener(MapSelectScreen.this.returnTo.getNotificationOverlay());
                ScreenManager.instance().showScreen(MapSelectScreen.this.returnTo);
            }
        }
    };

    protected MapSelectScreen() {
    }

    protected MapSelectScreen(Array<MapMetadata> maps, MapSelectScreenSettings settings, AbstractScreen returnTo) {
        this.init(maps, settings, returnTo);
    }

    protected void init(Array<MapMetadata> maps, MapSelectScreenSettings settings, AbstractScreen returnTo) {
        this.settings = settings;
        this.returnTo = returnTo;
        this.backButton = new G24TextButton("Back");
        this.backButton.addListener(this.onBackButton);
        this.rootTable.defaults().pad(10.0f);
        Image title = null;
        title = this instanceof MarketplaceScreen ? new Image(AssetManager.instance().loadTextureBlocking("textures/marketplace.png")) : new Image(AssetManager.instance().loadTextureBlocking("textures/map_select.png"));
        title.setScaling(Scaling.contain);
        this.rootTable.add(title).padTop(200.0f).colspan(2).center().maxWidth(800.0f);
        this.rootTable.row();
        this.entriesUI.pad(25.0f);
        this.entriesUI.space(30.0f);
        this.entriesUI.fill();
        this.entriesUI.grow();
        for (MapMetadata data : maps) {
            MapEntry e = new MapEntry(data);
            this.entriesUI.addActor(e);
            this.entries.add(e);
        }
        ScrollPane p = new ScrollPane((Actor)this.entriesUI, AbstractScreen.skin, "nobkg");
        p.setFadeScrollBars(false);
        p.setScrollBarPositions(false, true);
        p.setForceScroll(false, true);
        this.rootTable.add(p).top().colspan(2).maxHeight(0.75f * this.getUIStage().getHeight()).expandX();
        p.pack();
        this.rootTable.row();
        this.rootTable.add(this.backButton).bottom().left().expand();
        if (settings.creation) {
            final G24TextButton btn = new G24TextButton("Create New Map");
            btn.setProgrammaticChangeEvents(false);
            btn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (btn.isChecked()) {
                        btn.setChecked(false);
                        CreateMapDialog d = new CreateMapDialog(newName -> {
                            newName.ifPresent(newMap -> {
                                MapSelectScreen.this.entriesUI.addActor(new MapEntry(new MapMetadata((String)newMap, false)));
                                MapSelectScreen.this.entriesUI.pack();
                                MapSelectScreen.this.rootTable.pack();
                            });
                            return null;
                        });
                        d.show(MapSelectScreen.this.getUIStage());
                    }
                }
            });
            this.rootTable.add(btn).bottom().right().expand();
        }
        BackManager.addBack(() -> {
            if (User.isLoggedIn()) {
                ScreenManager.instance().showScreen(new OnlineMainMenu());
            } else {
                ScreenManager.instance().showScreen(new MainMenuScreen());
            }
        });
    }

    private static class MapSelectScreenSettings {
        boolean creation = false;
        boolean edit = false;
        boolean download = false;
        boolean verify = false;
        boolean upload = false;
        boolean play = false;
        boolean delete = false;

        private MapSelectScreenSettings() {
        }
    }

    protected class MapEntry
    extends ScrollPane {
        Table innerTable;
        MapMetadata data;

        private void addStats(MapMetadata.MapStats stats) {
            HorizontalGroup statGroup = new HorizontalGroup();
            statGroup.addActor(new StatLabel("Creator", stats.creator));
            statGroup.addActor(new StatLabel("Downloads", Long.toString(stats.downloads)));
            statGroup.addActor(new StatLabel("Attempts", Long.toString(stats.attempts)));
            statGroup.addActor(new StatLabel("Clears", Long.toString(stats.clears)));
            statGroup.space(10.0f);
            this.innerTable.add(statGroup).colspan(this.innerTable.getColumns()).center();
        }

        public MapEntry(MapMetadata metadata) {
            super(null, AbstractScreen.skin);
            this.innerTable = new Table();
            this.setStyle(AbstractScreen.skin.get("transparent", ScrollPane.ScrollPaneStyle.class));
            this.data = metadata;
            this.innerTable.setFillParent(true);
            this.innerTable.defaults().pad(10.0f).center();
            this.innerTable.add(new SmallLabel(metadata.name, "bubble"));
            if (((MapSelectScreen)MapSelectScreen.this).settings.play) {
                this.innerTable.add(new PlayButton());
            }
            if (((MapSelectScreen)MapSelectScreen.this).settings.edit && metadata.mapID.isEmpty()) {
                this.innerTable.add(new EditButton());
            }
            if (((MapSelectScreen)MapSelectScreen.this).settings.verify && User.isLoggedIn() && metadata.mapID.isEmpty()) {
                this.innerTable.add(new VerifyButton());
            }
            if (((MapSelectScreen)MapSelectScreen.this).settings.upload && metadata.mapID.isEmpty()) {
                this.innerTable.add(new UploadButton());
            }
            if (((MapSelectScreen)MapSelectScreen.this).settings.download) {
                this.innerTable.add(new DownloadButton());
            }
            if (!((MapSelectScreen)MapSelectScreen.this).settings.download) {
                this.innerTable.add(new CopyButton());
            }
            if (((MapSelectScreen)MapSelectScreen.this).settings.delete) {
                this.innerTable.add(new DeleteButton());
            }
            metadata.stats.ifPresent(s -> {
                this.innerTable.add(new InfoButton((MapMetadata.MapStats)s));
                this.innerTable.row();
                this.addStats((MapMetadata.MapStats)s);
            });
            this.setActor(this.innerTable);
        }

        private class PlayButton
        extends ImageButton {
            PlayButton() {
                super(AbstractScreen.skin, "play");
                this.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if (PlayButton.this.isChecked()) {
                            MapLoader.tryLoadMap(MapEntry.this.data, ((MapSelectScreen)MapSelectScreen.this).settings.creation).ifPresent(g -> ScreenManager.instance().showScreen(new SinglePlayerGameScreen((MapData)g, false)));
                        }
                    }
                });
            }
        }

        private class EditButton
        extends ImageButton {
            EditButton() {
                super(AbstractScreen.skin, "edit");
                this.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if (EditButton.this.isChecked()) {
                            MapLoader.tryLoadMap(MapEntry.this.data, ((MapSelectScreen)MapSelectScreen.this).settings.creation).ifPresent(g -> ScreenManager.instance().showScreen(new LevelEditorScreen((MapData)g)));
                        }
                    }
                });
            }
        }

        private class VerifyButton
        extends G24TextButton {
            VerifyButton() {
                super("Verify");
                this.pack();
                this.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if (VerifyButton.this.isChecked()) {
                            MapLoader.tryLoadMap(MapEntry.this.data, ((MapSelectScreen)MapSelectScreen.this).settings.creation).ifPresent(g -> ScreenManager.instance().showScreen(new SinglePlayerGameScreen((MapData)g, true)));
                        }
                    }
                });
            }
        }

        private class UploadButton
        extends ImageButton {
            UploadButton() {
                super(AbstractScreen.skin, "upload");
                this.setProgrammaticChangeEvents(false);
                this.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if (UploadButton.this.isChecked()) {
                            UploadButton.this.setChecked(false);
                            if (!User.isLoggedIn()) {
                                Notifier.error("You must be logged in to upload a map!");
                                return;
                            }
                            MapSelectScreen.this.waitFor(MapUploader.uploadMap(MapEntry.this.data), output -> {
                                output.reason.ifPresent(err -> Notifier.error(err));
                                output.response.ifPresent(rsp -> {
                                    Notifier.info(String.format("%s successfully uploaded!", MapEntry.this.data.name));
                                    System.out.println("MapID: `%s`\n");
                                });
                                return null;
                            }, "Uploading");
                        }
                    }
                });
            }
        }

        private class DownloadButton
        extends ImageButton {
            DownloadButton() {
                super(AbstractScreen.skin, "download");
                if (new File(MapEntry.this.data.locations.mapBasePath).exists()) {
                    this.setDisabled(true);
                    return;
                }
                this.setProgrammaticChangeEvents(false);
                this.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if (DownloadButton.this.isChecked()) {
                            DownloadButton.this.setChecked(false);
                            if (!User.isLoggedIn()) {
                                Notifier.error("You must be logged in to download a map!");
                                return;
                            }
                            MapSelectScreen.this.waitFor(MapDownloader.downloadMap(MapEntry.this.data), output -> {
                                output.reason.ifPresent(err -> Notifier.error(err));
                                output.response.ifPresent(rsp -> {
                                    DownloadButton.this.setDisabled(true);
                                    Notifier.info(String.format("%s successfully downloaded!", MapEntry.this.data.name));
                                });
                                return null;
                            }, "Downloading " + MapEntry.this.data.name);
                        }
                    }
                });
            }
        }

        private class CopyButton
        extends ImageButton {
            CopyButton() {
                super(AbstractScreen.skin, "copy");
                this.setProgrammaticChangeEvents(false);
                this.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if (CopyButton.this.isChecked()) {
                            CopyButton.this.setChecked(false);
                            CreateMapDialog d = new CreateMapDialog("Copy Name", newName -> {
                                newName.ifPresentOrElse(newMap -> {
                                    if (new File(new MapMetadata.MapLocation((String)newMap, (boolean)false).mapBasePath).exists()) {
                                        Notifier.error("Map with name \"" + newMap + "\" already exists!");
                                        return;
                                    }
                                    MapManager.copy(MapEntry.this.data, newMap).ifPresentOrElse(md -> {
                                        MapSelectScreen.this.entriesUI.addActor(new MapEntry((MapMetadata)md));
                                        MapSelectScreen.this.entriesUI.pack();
                                        MapSelectScreen.this.rootTable.pack();
                                    }, () -> Notifier.warn("Copy Failed"));
                                }, () -> Notifier.warn("No name provided, copy failed"));
                                return null;
                            });
                            d.show(MapSelectScreen.this.getUIStage());
                        }
                    }
                });
            }
        }

        private class DeleteButton
        extends ImageButton {
            DeleteButton() {
                super(AbstractScreen.skin, "toggleForbidden");
                this.setProgrammaticChangeEvents(false);
                this.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if (DeleteButton.this.isChecked()) {
                            final G24Dialog dialog = new G24Dialog("Are you sure?");
                            dialog.getContentTable().defaults().padLeft(10.0f).padRight(10.0f);
                            dialog.getContentTable().add(new SmallLabel("Are you sure you want to delete " + MapEntry.this.data.name + "?"));
                            dialog.getContentTable().row();
                            dialog.getContentTable().add(new SmallLabel("This will delete any custom object data or textures in this directory", "underline"));
                            dialog.getContentTable().row();
                            dialog.getContentTable().add(new SmallLabel("This cannot be undone", "underline"));
                            G24TextButton confirmButton = new G24TextButton("Delete");
                            dialog.getButtonTable().add(confirmButton);
                            confirmButton.addListener(new ChangeListener(){

                                @Override
                                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                    MapSaver.deleteMap(MapEntry.this.data);
                                    MapEntry.this.remove();
                                    MapSelectScreenBuilder.maps.removeValue(MapEntry.this.data, false);
                                    dialog.hide();
                                    Notifier.info("Successfully deleted map.");
                                }
                            });
                            G24TextButton cancelButton = new G24TextButton("Cancel");
                            dialog.getButtonTable().add(cancelButton);
                            cancelButton.addListener(new ChangeListener(){

                                @Override
                                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                    DeleteButton.this.setChecked(false);
                                    dialog.hide();
                                }
                            });
                            dialog.show(DeleteButton.this.getStage());
                        }
                    }
                });
            }
        }

        private class InfoButton
        extends ImageButton {
            InfoButton(final MapMetadata.MapStats stats) {
                super(AbstractScreen.skin, "info");
                this.setProgrammaticChangeEvents(false);
                this.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if (InfoButton.this.isChecked()) {
                            InfoButton.this.setChecked(false);
                            new MapStatDialog(MapEntry.this.data, stats).show(InfoButton.this.getStage());
                        }
                    }
                });
            }
        }
    }

    public static class MapSelectScreenBuilder {
        private static Array<MapMetadata> maps = new Array();
        private static AbstractScreen returnTo = null;
        private static MapSelectScreenSettings settings = new MapSelectScreenSettings();

        public MapSelectScreenBuilder(AbstractScreen back) {
            settings = new MapSelectScreenSettings();
            maps = new Array();
            returnTo = back;
            NotificationBus.get().removeListener(returnTo.getNotificationOverlay());
        }

        public static Array<MapMetadata> getMaps() {
            return maps;
        }

        public static AbstractScreen getReturnTo() {
            return returnTo;
        }

        public static MapSelectScreenSettings getSettings() {
            return settings;
        }

        public MapSelectScreenBuilder(boolean previousSettings) {
            if (!previousSettings) {
                settings = new MapSelectScreenSettings();
                maps = new Array();
                returnTo = null;
            } else {
                maps = MapLoader.discoverMaps();
            }
        }

        public MapSelectScreenBuilder withMaps(Array<MapMetadata> maps) {
            MapSelectScreenBuilder.maps = maps;
            return this;
        }

        public MapSelectScreenBuilder creation() {
            MapSelectScreenBuilder.settings.creation = true;
            return this;
        }

        public MapSelectScreenBuilder play() {
            MapSelectScreenBuilder.settings.play = true;
            return this;
        }

        public MapSelectScreenBuilder edit() {
            MapSelectScreenBuilder.settings.edit = true;
            return this;
        }

        public MapSelectScreenBuilder verify() {
            MapSelectScreenBuilder.settings.verify = true;
            return this;
        }

        public MapSelectScreenBuilder delete() {
            MapSelectScreenBuilder.settings.delete = true;
            return this;
        }

        public MapSelectScreenBuilder download() {
            MapSelectScreenBuilder.settings.download = true;
            return this;
        }

        public MapSelectScreenBuilder upload() {
            MapSelectScreenBuilder.settings.upload = true;
            return this;
        }

        public MapSelectScreen build() {
            return new MapSelectScreen(maps, settings, returnTo);
        }
    }

    public static class StatLabel
    extends SmallLabel {
        public StatLabel(String label, String value) {
            super(label + ": " + value, "bubble_gray", 0.6f);
        }
    }
}

