/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.data.Networking;
import group24.escaperoom.data.Types;
import group24.escaperoom.screens.MapSelectScreen;
import group24.escaperoom.screens.OnlineMainMenu;
import group24.escaperoom.ui.FilterUI;
import group24.escaperoom.ui.widgets.G24TextButton;
import java.util.function.BiFunction;

public class MarketplaceScreen
extends MapSelectScreen {
    private FilterUI filterUI;
    private G24TextButton filterButton = new G24TextButton("Filter Results");
    BiFunction<Types.Filters, Types.Sort, Void> onSearch = (arr, sort) -> {
        this.waitFor(Networking.listMapMetadata((Types.ListMapsRequest)new Types.ListMapsRequest().withLimit(10).withSort((Types.Sort)sort).withFilters((Types.Filters)arr)), (T rsp) -> {
            this.entriesUI.clear();
            this.entries.clear();
            for (MapMetadata data : rsp.metadata) {
                data.locations = new MapMetadata.MapLocation(data.mapID, false);
                MapSelectScreen.MapEntry e = new MapSelectScreen.MapEntry(data);
                this.entriesUI.addActor(e);
                this.entries.add(e);
            }
            return null;
        }, "Applying filters...");
        return null;
    };
    private ChangeListener onFilter = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            MarketplaceScreen.this.filterButton.setChecked(false);
            MarketplaceScreen.this.filterUI.pack();
            MarketplaceScreen.this.filterUI.toFront();
            MarketplaceScreen.this.filterUI.setPosition(MarketplaceScreen.this.getUIStage().getWidth() / 2.0f - MarketplaceScreen.this.filterUI.getWidth() / 2.0f, MarketplaceScreen.this.getUIStage().getHeight() / 2.0f - MarketplaceScreen.this.filterUI.getHeight() / 2.0f);
            MarketplaceScreen.this.filterUI.setVisible(true);
        }
    };

    public MarketplaceScreen() {
        this.filterUI = new FilterUI(this.onSearch, Types.ListMapsRequest.Field.class);
        this.filterButton.addListener(this.onFilter);
        this.filterButton.setProgrammaticChangeEvents(false);
        this.waitFor(Networking.listMapMetadata((Types.ListMapsRequest)new Types.ListMapsRequest().withLimit(10).withSort(new Types.Sort("name"))), (T rsp) -> {
            rsp.metadata.forEach(meta -> {
                meta.locations = new MapMetadata.MapLocation(meta.mapID, false);
            });
            new MapSelectScreen.MapSelectScreenBuilder(new OnlineMainMenu()).download().withMaps(rsp.metadata);
            this.init(MapSelectScreen.MapSelectScreenBuilder.getMaps(), MapSelectScreen.MapSelectScreenBuilder.getSettings(), MapSelectScreen.MapSelectScreenBuilder.getReturnTo());
            this.rootTable.add(this.filterButton).bottom().right().expand();
            this.filterUI.setVisible(false);
            this.addUI(this.filterUI);
            return null;
        }, "Fetching maps...");
    }
}

