/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import group24.escaperoom.AssetManager;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.ui.SmallLabel;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public abstract class MenuScreen
extends AbstractScreen {
    Texture background;
    Table rootTable;

    public MenuScreen() {
        AssetManager.instance().load("textures/brick.png", Texture.class);
        AssetManager.instance().finishLoadingAsset("textures/brick.png");
        this.background = AssetManager.instance().get("textures/brick.png", Texture.class);
        this.addSprite(this.background, 0.0f, 0.0f, 48.0f, 27.0f);
        this.rootTable = new Table();
        this.rootTable.setFillParent(true);
        this.addUI(this.rootTable);
    }

    public <T> void waitFor(CompletableFuture<T> future, Function<T, Void> onComplete, Actor loadActor) {
        this.rootTable.remove();
        this.addUI(loadActor);
        future.thenAccept(t -> Gdx.app.postRunnable(() -> {
            onComplete.apply(t);
            loadActor.remove();
            this.addUI(this.rootTable);
        }));
    }

    public <T> void waitFor(CompletableFuture<T> future, Function<T, Void> onComplete, String loadMessage) {
        SmallLabel l = new SmallLabel(loadMessage, "bubble");
        l.setPosition(this.getUIStage().getWidth() / 2.0f, this.getUIStage().getHeight() / 2.0f, 1);
        l.pack();
        this.addUI(l);
        l.addAction(Actions.repeat(10, Actions.sequence(Actions.delay(0.3f), Actions.run(() -> {
            l.setText(loadMessage + ".");
            l.pack();
        }), Actions.delay(0.3f), Actions.run(() -> {
            l.setText(loadMessage + "..");
            l.pack();
        }), Actions.delay(0.3f), Actions.run(() -> {
            l.setText(loadMessage + "...");
            l.pack();
        }), Actions.delay(0.3f), Actions.run(() -> {
            l.setText(loadMessage + "....");
            l.pack();
        }))));
        this.waitFor(future, onComplete, l);
    }

    public <T> void waitFor(CompletableFuture<T> future, Function<T, Void> onComplete) {
        this.waitFor(future, onComplete, "Loading");
    }
}

