/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Scaling;
import group24.escaperoom.AssetManager;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.data.MapLoader;
import group24.escaperoom.data.User;
import group24.escaperoom.screens.LeaderboardScreen;
import group24.escaperoom.screens.MainMenuScreen;
import group24.escaperoom.screens.MapSelectScreen;
import group24.escaperoom.screens.MarketplaceScreen;
import group24.escaperoom.screens.MenuScreen;
import group24.escaperoom.ui.widgets.G24TextButton;

public class OnlineMainMenu
extends MenuScreen {
    G24TextButton myMapsButton = new G24TextButton("My Maps");
    private ChangeListener onMyMaps = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            ScreenManager.instance().showScreen(new MapSelectScreen.MapSelectScreenBuilder(new OnlineMainMenu()).withMaps(MapLoader.discoverMaps()).edit().play().delete().creation().verify().build());
        }
    };
    G24TextButton logOutButton = new G24TextButton("Log Out");
    private ChangeListener onLogOut = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            User.logOut();
            ScreenManager.instance().showScreen(new MainMenuScreen());
        }
    };
    G24TextButton marketPlaceButton = new G24TextButton("Marketplace");
    private ChangeListener onMarketplace = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            ScreenManager.instance().showScreen(new MarketplaceScreen());
        }
    };
    G24TextButton leaderBoardButton = new G24TextButton("Leaderboard");
    private ChangeListener onLeaderboard = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            ScreenManager.instance().showScreen(new LeaderboardScreen());
        }
    };

    public OnlineMainMenu() {
        this.myMapsButton.addListener(this.onMyMaps);
        this.logOutButton.addListener(this.onLogOut);
        this.marketPlaceButton.addListener(this.onMarketplace);
        this.leaderBoardButton.addListener(this.onLeaderboard);
        this.rootTable.defaults().pad(10.0f);
        Image title_img = null;
        try {
            String path = "textures/title_online.png";
            AssetManager.instance().load(path, Texture.class);
            AssetManager.instance().finishLoadingAsset(path);
            title_img = new Image(AssetManager.instance().get(path, Texture.class));
            title_img.setScaling(Scaling.contain);
        }
        catch (Exception gdxre) {
            System.err.println("failed to load title img");
            return;
        }
        this.rootTable.add(title_img).center().padLeft(20.0f).padRight(20.0f).padBottom(0.0f);
        this.rootTable.row();
        this.rootTable.add(this.myMapsButton).minWidth(300.0f);
        this.rootTable.row();
        this.rootTable.add(this.marketPlaceButton).minWidth(300.0f);
        this.rootTable.row();
        this.rootTable.add(this.leaderBoardButton).minWidth(300.0f);
        this.rootTable.row();
        this.rootTable.add(this.logOutButton).minWidth(300.0f);
        this.rootTable.setFillParent(true);
    }
}

