/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.data.Grid;
import group24.escaperoom.data.MapData;
import group24.escaperoom.data.MapLoader;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.objects.ObjectLoader;
import group24.escaperoom.entities.player.PlayerDetails;
import group24.escaperoom.entities.properties.PlayerProperty;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.GameScreen;
import group24.escaperoom.screens.GameSummaryScreen;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.ScreenShotter;
import group24.escaperoom.ui.widgets.G24TextButton;
import java.util.Optional;
import java.util.function.Predicate;

public class SinglePlayerGameScreen
extends GameScreen {
    G24TextButton editButton = new G24TextButton("Back to Editor");

    public SinglePlayerGameScreen(MapData data, boolean verifying) {
        super(data);
        this.applyGrid(data.getGrid());
        GameScreen.GameType gameType = this.gameType = verifying ? GameScreen.GameType.Verifying : GameScreen.GameType.Standard;
        if (verifying) {
            this.actionlog.setVisible(false);
            this.render(0.0f);
            ScreenShotter.takeScreenShot(data.getMetadata());
            this.actionlog.setVisible(true);
        }
    }

    public SinglePlayerGameScreen(MapData mapdata) {
        super(mapdata);
        this.applyGrid(mapdata.getGrid());
        this.gameType = GameScreen.GameType.Editor;
    }

    private void applyGrid(Grid grid) {
        this.loadGrid(grid);
        this.loadPlayer();
    }

    public void loadPlayer() {
        Optional<Item> playerStart = this.grid.findItemWhere(new Predicate<Item>(){

            @Override
            public boolean test(Item arg0) {
                return arg0.hasProperty(PropertyType.Player);
            }
        });
        Item playerItem = playerStart.orElse(new Item(ObjectLoader.LoadedObjects.getItem("GameControl", "Mr. E").get()));
        player.setPosition(playerItem.getX(), playerItem.getY());
        player.setSize(playerItem.getWidth(), playerItem.getHeight());
        playerItem.remove();
        PlayerDetails details = playerItem.getProperty(PropertyType.Player, PlayerProperty.class).get().getDetails();
        player.setTexture(playerItem.getTexture());
        SinglePlayerGameScreen.player.renderPriority = playerItem.renderPriority();
        this.playerId = playerItem.getID();
        this.followActor = Optional.of(player);
        player.setDetails(details);
    }

    @Override
    protected void init() {
        this.editButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (SinglePlayerGameScreen.this.editButton.isChecked()) {
                    MapLoader.tryLoadMap(SinglePlayerGameScreen.this.metadata).ifPresent(g -> ScreenManager.instance().showScreen(new LevelEditorScreen((MapData)g)));
                }
            }
        });
        if (this.gameType == GameScreen.GameType.Editor) {
            this.rootTable.add(this.editButton).right().bottom().expandX();
        }
    }

    @Override
    public void render(float delta) {
        super.render(delta);
        player.stepAnimation(delta);
    }

    public void completeLevel(boolean success) {
        this.calculateStatistics(success);
        ScreenManager.instance().showScreen(new GameSummaryScreen(this.stats, this.metadata, this.gameType));
    }
}

