/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens.editor;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.control.Input;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.Tooltip;
import java.util.Optional;

public class ActionHistory {
    private final Array<EditorAction> actions = new Array();
    private int index = -1;
    private final ImageButton undoButton = new ImageButton(AbstractScreen.skin, "undo");
    private final ImageButton redoButton = new ImageButton(AbstractScreen.skin, "redo");

    private void buildToolTip(String title, Input input, Actor target) {
        String label = title;
        label = label + "\n Hotkey(s): " + String.join((CharSequence)"\n", input.description().bindings);
        SmallLabel l = new SmallLabel(label, "bubble_gray", 0.65f);
        l.pack();
        new Tooltip.Builder(l).target(target, () -> Optional.of(target.getStage())).build();
    }

    public ActionHistory() {
        this.undoButton.setProgrammaticChangeEvents(false);
        this.undoButton.setDisabled(true);
        this.undoButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (ActionHistory.this.undoButton.isChecked()) {
                    ActionHistory.this.undoButton.setChecked(false);
                    ActionHistory.this.undo();
                }
            }
        });
        this.buildToolTip("Undo", Input.UNDO, this.undoButton);
        this.redoButton.setProgrammaticChangeEvents(false);
        this.redoButton.setDisabled(true);
        this.redoButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (ActionHistory.this.redoButton.isChecked()) {
                    ActionHistory.this.redoButton.setChecked(false);
                    ActionHistory.this.redo();
                }
            }
        });
        this.buildToolTip("Redo", Input.REDO, this.redoButton);
    }

    public ImageButton getUndoButton() {
        return this.undoButton;
    }

    public ImageButton getRedoButton() {
        return this.redoButton;
    }

    public void record(EditorAction action) {
        for (int i = this.actions.size - 1; i > this.index; --i) {
            this.actions.pop();
        }
        this.undoButton.setDisabled(false);
        this.redoButton.setDisabled(true);
        this.actions.add(action);
        ++this.index;
    }

    public boolean undo() {
        if (this.index >= 0) {
            this.actions.get(this.index).undoAction();
            --this.index;
            if (this.index <= 0) {
                this.undoButton.setDisabled(true);
            }
            this.redoButton.setDisabled(false);
            return true;
        }
        return false;
    }

    public boolean redo() {
        if (this.index < this.actions.size - 1) {
            ++this.index;
            this.actions.get(this.index).doAction();
            if (this.index >= this.actions.size - 1) {
                this.redoButton.setDisabled(true);
            }
            this.undoButton.setDisabled(false);
            return true;
        }
        return false;
    }

    public static interface EditorAction {
        public void doAction();

        public void undoAction();
    }
}

