/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens.editor;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class CamMan {
    private OrthographicCamera cam;
    static final float MAX_ZOOM = 8.0f;
    static final float MIN_ZOOM = 0.2f;
    static final float ZOOM_INCR = 0.03f;
    static final Interpolation transInterpolation = Interpolation.pow2Out;

    public CamMan(OrthographicCamera camera) {
        this.cam = camera;
    }

    public Vector2 unproject(float x, float y) {
        Vector3 unproj = this.cam.unproject(new Vector3(x, y, 0.0f));
        return new Vector2(unproj.x, unproj.y);
    }

    private float translationFactor() {
        float zoomProgress = MathUtils.map(0.2f, 8.0f, 0.0f, 1.0f, this.cam.zoom);
        float transProgress = transInterpolation.apply(zoomProgress);
        return transProgress;
    }

    private float translationScalar() {
        float translationScalar = MathUtils.map(0.0f, 1.0f, 0.03f, 1.0f, this.translationFactor());
        return translationScalar;
    }

    public void translate(float dx, float dy) {
        this.cam.translate(dx, dy);
    }

    public void setPosition(float x, float y) {
        this.cam.position.set(x, y, 0.0f);
    }

    public void translate(Translation translation) {
        switch (translation) {
            case Right: {
                this.cam.position.add(this.translationScalar(), 0.0f, 0.0f);
                break;
            }
            case Left: {
                this.cam.position.add(-this.translationScalar(), 0.0f, 0.0f);
                break;
            }
            case Up: {
                this.cam.position.add(0.0f, this.translationScalar(), 0.0f);
                break;
            }
            case Down: {
                this.cam.position.add(0.0f, -this.translationScalar(), 0.0f);
            }
        }
    }

    public void setZoom(float zoom) {
        this.cam.zoom = MathUtils.clamp(zoom, 0.2f, 8.0f);
    }

    public void zoomOut() {
        this.cam.zoom = MathUtils.clamp(this.cam.zoom + 0.03f, 0.2f, 8.0f);
    }

    public void zoomIn() {
        this.cam.zoom = MathUtils.clamp(this.cam.zoom - 0.03f, 0.2f, 8.0f);
    }

    public static enum Translation {
        Up,
        Down,
        Right,
        Left;

    }
}

