/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens.editor;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.screens.editor.ActionHistory;
import java.util.logging.Logger;

public class DragManager {
    private Logger log = Logger.getLogger(DragManager.class.getName());
    private final DragAndDrop dragAndDrop;
    private Item inFlightItem = null;
    private final LevelEditorScreen screen;
    private final Actor proxy;

    public DragAndDrop getDragAndDrop() {
        return this.dragAndDrop;
    }

    public Item getInFlightItem() {
        return this.inFlightItem;
    }

    public DragManager(LevelEditorScreen screen, Actor roomProxy) {
        this.screen = screen;
        this.dragAndDrop = new DragAndDrop();
        this.proxy = roomProxy;
        this.dragAndDrop.addTarget(new EditorTarget(this.proxy));
    }

    private class EditorTarget
    extends DragAndDrop.Target {
        public EditorTarget(Actor target) {
            super(target);
        }

        @Override
        public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            Types.IntVector2 gameCoords = Types.IntVector2.fromVector2(DragManager.this.screen.getViewport().unproject(new Vector2(Gdx.input.getX(), Gdx.input.getY())));
            if (!gameCoords.contained(0, 0, ((DragManager)DragManager.this).screen.grid.getWidth() - 1, ((DragManager)DragManager.this).screen.grid.getHeight() - 1)) {
                return false;
            }
            if (DragManager.this.inFlightItem == null) {
                DragManager.this.inFlightItem = ((Item)payload.getObject()).clone();
                DragManager.this.inFlightItem.setAlpha(0.75f);
            }
            if (DragManager.this.screen.canPlace(DragManager.this.inFlightItem, gameCoords)) {
                if (DragManager.this.screen.placeItem(DragManager.this.inFlightItem)) {
                    DragManager.this.screen.recordEditorAction(new PlacementAction(DragManager.this.inFlightItem, DragManager.this.screen));
                }
                if (DragManager.this.inFlightItem.getPosition().equals(gameCoords)) {
                    return true;
                }
                DragManager.this.inFlightItem.moveTo(gameCoords.x, gameCoords.y);
                return true;
            }
            return false;
        }

        @Override
        public void reset(DragAndDrop.Source source, DragAndDrop.Payload payload) {
            if (DragManager.this.inFlightItem == null) {
                return;
            }
            DragManager.this.inFlightItem.setAlpha(1.0f);
            DragManager.this.inFlightItem.setContained(false);
            DragManager.this.inFlightItem.remove();
            DragManager.this.inFlightItem = null;
            CursorManager.restoreDefault();
        }

        @Override
        public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            if (DragManager.this.inFlightItem == null) {
                return;
            }
            DragManager.this.inFlightItem.setAlpha(1.0f);
            DragManager.this.inFlightItem = null;
        }
    }

    public static class PlacementAction
    implements ActionHistory.EditorAction {
        final Item obj;
        final MapScreen screen;

        public PlacementAction(Item obj, MapScreen screen) {
            this.obj = obj;
            this.screen = screen;
        }

        @Override
        public void doAction() {
            this.screen.placeItem(this.obj);
        }

        @Override
        public void undoAction() {
            this.obj.remove();
        }
    }
}

