/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens.editor;

import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.editor.ItemDecoration;
import java.util.Collection;

public interface GridView {
    public ItemDecoration decorate(Item var1);

    default public void apply(Collection<Item> items) {
        for (Item item : items) {
            ItemDecoration decoration = this.decorate(item);
            if (decoration == null) continue;
            decoration.applyTo(item);
        }
    }

    default public void reset(Collection<Item> items) {
        for (Item item : items) {
            ItemDecoration decoration = this.decorate(item);
            if (decoration == null) continue;
            decoration.removeFrom(item);
        }
    }

    public static GridView compose(final GridView ... views) {
        GridView gridView = new GridView(){

            @Override
            public ItemDecoration decorate(Item item) {
                ItemDecoration merged = new ItemDecoration();
                for (GridView view : views) {
                    ItemDecoration decoration = view.decorate(item);
                    if (decoration == null) continue;
                    merged.merge(decoration);
                }
                return merged.hasModifications() ? merged : null;
            }
        };
        return gridView;
    }
}

