/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens.editor;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.entities.Item;
import java.util.HashMap;
import java.util.Map;

public class ItemDecoration {
    private final HashMap<Decoration<?>, Object> decorations = new HashMap();
    private static final Merger<Color> ColorMerger = (one, two) -> new Color((one.r + two.r) / 2.0f, (one.g + two.g) / 2.0f, (one.b + two.b) / 2.0f, (one.a + two.a) / 2.0f);
    private static final Merger<Boolean> RequireBoth = (one, two) -> one != false && two != false;
    private static final Merger<Boolean> Either = (one, two) -> one != false || two != false;
    public static final Decoration<Color> COLOR = new Decoration(ColorMerger);
    public static final Decoration<Boolean> DIMMED = new Decoration(RequireBoth);
    public static final Decoration<Boolean> HIGHTLIGHT = new Decoration(Either);
    public static final Decoration<Boolean> GRAYSCALE = new Decoration(RequireBoth);

    public <T> ItemDecoration set(@Null Decoration<T> decoration, T val) {
        if (val != null) {
            this.decorations.put(decoration, val);
        } else {
            this.decorations.remove(decoration);
        }
        return this;
    }

    public ItemDecoration merge(ItemDecoration other) {
        for (Map.Entry<Decoration<?>, Object> entry : other.decorations.entrySet()) {
            Decoration<?> deco = entry.getKey();
            this.mergeProperty(deco, entry.getValue());
        }
        return this;
    }

    private <T> void mergeProperty(Decoration<T> decoration, Object newValue) {
        if (!this.decorations.containsKey(decoration)) {
            this.decorations.put(decoration, newValue);
        } else {
            Object existing = this.decorations.get(decoration);
            Object merged = decoration.merger.merge(existing, newValue);
            this.decorations.put(decoration, merged);
        }
    }

    public void applyTo(Item item) {
        if (this.has(COLOR)) {
            item.setColor(this.get(COLOR));
        }
        if (this.has(GRAYSCALE) && this.get(GRAYSCALE).booleanValue()) {
            item.setColor(0.5f, 0.5f, 0.5f, 1.0f);
        }
        if (this.has(DIMMED)) {
            item.setDimmed(this.get(DIMMED));
        }
        if (this.has(HIGHTLIGHT)) {
            item.setHighlighed(this.get(HIGHTLIGHT));
        }
    }

    public void removeFrom(Item item) {
        if (this.has(COLOR) || this.has(GRAYSCALE)) {
            item.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.has(DIMMED)) {
            item.setDimmed(false);
        }
        if (this.has(HIGHTLIGHT)) {
            item.setHighlighed(false);
        }
    }

    public boolean hasModifications() {
        return this.decorations.size() > 0;
    }

    private <T> T get(Decoration<T> property) {
        return (T)this.decorations.get(property);
    }

    private boolean has(Decoration<?> decoration) {
        return this.decorations.containsKey(decoration);
    }

    public static class Decoration<T> {
        Merger<T> merger;

        private Decoration(Merger<T> decorationMerger) {
            this.merger = decorationMerger;
        }
    }

    public static interface Merger<T> {
        public T merge(T var1, T var2);
    }
}

